/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config;

import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
final class WidgetFactory {
    private WidgetFactory() {
    }

    static AbstractWidget create(ModConfigSpec.ConfigValue<?> configValue) {
        String stringValue;
        Object currentValue = configValue.get();
        if (currentValue instanceof Boolean) {
            Boolean booleanValue = (Boolean)currentValue;
            return Checkbox.builder((Component)Component.empty(), (Font)Minecraft.getInstance().font).pos(0, 0).selected(booleanValue.booleanValue()).build();
        }
        if (currentValue instanceof Number || currentValue instanceof String && !ColorUtil.isHexColor(stringValue = (String)currentValue)) {
            EditBox editBox = new EditBox(Minecraft.getInstance().font, 0, 0, 100, 20, (Component)Component.empty());
            editBox.setMaxLength(512);
            editBox.setValue(String.valueOf(currentValue));
            if (currentValue instanceof Number) {
                editBox.setFilter(WidgetFactory::numericCandidate);
            }
            return editBox;
        }
        if (currentValue instanceof Enum) {
            Enum enumValue = (Enum)currentValue;
            List<Enum> enumValues = Arrays.asList((Enum[])enumValue.getDeclaringClass().getEnumConstants());
            return CycleButton.builder(e -> Component.literal((String)e.name())).withValues(enumValues).displayOnlyValue().withInitialValue((Object)enumValue).create(0, 0, 100, 20, (Component)Component.empty(), (button, value) -> {});
        }
        return null;
    }

    private static boolean numericCandidate(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ("0123456789.,-+eE _".indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }
}

