/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.color;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.color.ColorUtil;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.awt.Color;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ColorPickerScreen
extends Screen {
    private static final int SQUARE = 100;
    private static final int BAR_W = 20;
    private static final int BAR_GAP = 3;
    private static final int PREVIEW_SZ = 40;
    private static final int HEX_W = 100;
    private static final int CTRL_W = 200;
    private static final int PADDING = 10;
    private static final int GAP = 10;
    private static final int HEADER_H = 60;
    private static final int FOOTER_H = 40;
    private static final int EXPAND_MS = 150;
    private static final int FADE_MS = 300;
    private static final int BASE_REACH = 1;
    private static final int MAX_REACH = 2;
    private static final float GRID_DENOM_F = Math.max(1.0f, 99.0f);
    private static final int GRID_DENOM_I = Math.max(1, 99);
    private static final float STICKY_EPS = 0.003921569f;
    private final ConfigScreen parent;
    private final String fullPath;
    private final String initialHex;
    private long pressStartMs = 0L;
    private long releaseStartMs = 0L;
    private boolean draggingSquare = false;
    private boolean draggingHue = false;
    private float hue;
    private float saturation;
    private float brightness;
    private EditBox hexBox;
    private ColorSlider hueSlider;
    private ColorSlider saturationSlider;
    private ColorSlider brightnessSlider;
    private int squareX;
    private int squareY;
    private int barX;
    private int barY;
    private int panelX;
    private int panelY;
    private int panelW;
    private int panelH;
    private int headerY;
    private int footerY;
    private int headerStartX;
    private AnimatedScreenTitle animatedTitle;
    private boolean suppressHexResponder = false;

    public ColorPickerScreen(ConfigScreen parent, String title, String fullPath, String currentHex) {
        super((Component)Component.literal((String)("Pick " + title)));
        this.parent = parent;
        this.fullPath = fullPath;
        this.initialHex = currentHex == null || currentHex.isEmpty() ? "FFFFFF" : currentHex;
    }

    protected void init() {
        super.init();
        this.parseHex(this.initialHex);
        this.computeLayout();
        this.clearWidgets();
        int headerContentW = 150;
        this.headerStartX = this.panelX + (this.panelW - headerContentW) / 2;
        this.hexBox = new EditBox(this.font, this.headerStartX + 40 + 10, this.headerY + 20, 100, 20, (Component)Component.empty());
        this.hexBox.setMaxLength(6);
        this.hexBox.setValue(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
        this.hexBox.setResponder(this::onHexChanged);
        this.addRenderableWidget((GuiEventListener)this.hexBox);
        int sliderH = 20;
        int sGap = 4;
        int innerY = this.headerY + 60 + 10;
        this.hueSlider = new ColorSlider(this.panelX + 10, innerY, 200, sliderH, "Hue", this.hue, this::onHue);
        this.saturationSlider = new ColorSlider(this.panelX + 10, innerY + sliderH + sGap, 200, sliderH, "Saturation", this.saturation, this::onSaturation);
        this.brightnessSlider = new ColorSlider(this.panelX + 10, innerY + 2 * (sliderH + sGap), 200, sliderH, "Brightness", this.brightness, this::onBrightness);
        this.addRenderableWidget((GuiEventListener)this.hueSlider);
        this.addRenderableWidget((GuiEventListener)this.saturationSlider);
        this.addRenderableWidget((GuiEventListener)this.brightnessSlider);
        int btnW = 60;
        int btnH = 20;
        int btnY = this.footerY + (40 - btnH) / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), b -> this.save()).pos(this.panelX + (this.panelW - btnW * 2 - 10) / 2, btnY).size(btnW, btnH).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onClose()).pos(this.panelX + (this.panelW + 10) / 2, btnY).size(btnW, btnH).build());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.title.getString());
        }
        this.animatedTitle.avoidRightEdge(() -> this.panelX + this.panelW);
    }

    private void computeLayout() {
        this.panelW = 220;
        this.panelH = 202;
        int groupW = 133 + this.panelW;
        int groupH = this.panelH;
        int originX = (this.width - groupW) / 2;
        int originY = (this.height - groupH) / 2;
        this.squareX = originX;
        this.squareY = originY + (groupH - 100) / 2;
        this.barX = this.squareX + 100 + 3;
        this.barY = this.squareY;
        this.panelX = this.barX + 20 + 10;
        this.headerY = this.panelY = originY;
        this.footerY = this.panelY + this.panelH - 40;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.animatedTitle.render(guiGraphics, this.font, this.width);
        this.drawHueBar(guiGraphics);
        this.drawSquare(guiGraphics);
        this.drawHueCursor(guiGraphics);
        this.drawSquareCursor(guiGraphics);
        int argb = ColorUtil.hexToARGB(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
        guiGraphics.fill(this.headerStartX, this.headerY + 10, this.headerStartX + 40, this.headerY + 10 + 40, argb);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean mouseClicked(double mx, double my, int btn) {
        if (btn == 0) {
            this.clearHexFocusIfNotHovered(mx, my);
            if (ColorPickerScreen.in(mx, my, this.squareX, this.squareY, 100)) {
                this.draggingSquare = true;
                this.pressStartMs = Util.getMillis();
                this.releaseStartMs = 0L;
                this.setSaturationBrightnessFromMouse(mx, my);
                return true;
            }
            if (ColorPickerScreen.in(mx, my, this.barX, this.barY, 20)) {
                this.draggingHue = true;
                this.setHueFromMouse(my);
                return true;
            }
        }
        return super.mouseClicked(mx, my, btn);
    }

    public boolean mouseDragged(double mx, double my, int btn, double dx, double dy) {
        if (btn == 0) {
            if (this.draggingSquare) {
                this.setSaturationBrightnessFromMouse(mx, my);
                return true;
            }
            if (this.draggingHue) {
                this.setHueFromMouse(my);
                return true;
            }
        }
        return super.mouseDragged(mx, my, btn, dx, dy);
    }

    public boolean mouseReleased(double mx, double my, int btn) {
        if (btn == 0) {
            if (this.draggingSquare) {
                this.draggingSquare = false;
                this.releaseStartMs = Util.getMillis();
                return true;
            }
            if (this.draggingHue) {
                this.draggingHue = false;
                return true;
            }
        }
        return super.mouseReleased(mx, my, btn);
    }

    private void setHueFromMouse(double my) {
        this.hue = Mth.clamp((float)((float)((my - (double)this.barY) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        this.hueSlider.setSilently(this.hue);
        this.syncHex();
    }

    private void setSaturationBrightnessFromMouse(double mx, double my) {
        this.saturation = Mth.clamp((float)((float)((mx - (double)this.squareX) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        this.brightness = 1.0f - Mth.clamp((float)((float)((my - (double)this.squareY) / (double)GRID_DENOM_F)), (float)0.0f, (float)1.0f);
        this.saturationSlider.setSilently(this.saturation);
        this.brightnessSlider.setSilently(this.brightness);
        this.syncHex();
    }

    private static boolean in(double px, double py, int x, int y, int w) {
        return px >= (double)x && px < (double)(x + w) && py >= (double)y && py < (double)(y + 100);
    }

    private void drawHueBar(GuiGraphics guiGraphics) {
        for (int i = 0; i < 100; ++i) {
            float t = (float)i / GRID_DENOM_F;
            guiGraphics.fill(this.barX, this.barY + i, this.barX + 20, this.barY + i + 1, ColorPickerScreen.hsvToARGB(t, 1.0f, 1.0f));
        }
    }

    private void drawSquare(GuiGraphics guiGraphics) {
        for (int r = 0; r < 100; ++r) {
            float v = 1.0f - (float)r / GRID_DENOM_F;
            for (int c = 0; c < 100; ++c) {
                float s = (float)c / GRID_DENOM_F;
                guiGraphics.fill(this.squareX + c, this.squareY + r, this.squareX + c + 1, this.squareY + r + 1, ColorPickerScreen.hsvToARGB(this.hue, s, v));
            }
        }
    }

    private void drawHueCursor(GuiGraphics guiGraphics) {
        int y = this.barY + Mth.clamp((int)Math.round(this.hue * (float)GRID_DENOM_I), (int)0, (int)99);
        guiGraphics.fill(this.barX, y - 1, this.barX + 20, y + 1, -1);
    }

    private void drawSquareCursor(GuiGraphics guiGraphics) {
        int cx = this.squareX + Mth.clamp((int)Math.round(this.saturation * (float)GRID_DENOM_I), (int)0, (int)99);
        int cy = this.squareY + Mth.clamp((int)Math.round((1.0f - this.brightness) * (float)GRID_DENOM_I), (int)0, (int)99);
        guiGraphics.fill(cx - 2, cy, cx + 3, cy + 1, -1);
        guiGraphics.fill(cx, cy - 2, cx + 1, cy + 3, -1);
        long now = Util.getMillis();
        if (this.draggingSquare) {
            float t = Mth.clamp((float)((float)(now - this.pressStartMs) / 150.0f), (float)0.0f, (float)1.0f);
            int reach = 1 + Math.round(1.0f * t);
            ColorPickerScreen.drawBurst(guiGraphics, cx, cy, reach, -1);
        } else if (this.releaseStartMs != 0L) {
            float t = (float)(now - this.releaseStartMs) / 300.0f;
            if (t >= 1.0f) {
                this.releaseStartMs = 0L;
                return;
            }
            int reach = Math.round(2.0f * (1.0f - t));
            int col = (int)((1.0f - t) * 255.0f) << 24 | 0xFFFFFF;
            ColorPickerScreen.drawBurst(guiGraphics, cx, cy, reach, col);
        }
    }

    private static void drawBurst(GuiGraphics guiGraphics, int cx, int cy, int reach, int col) {
        guiGraphics.fill(cx - reach - 2, cy, cx + reach + 3, cy + 1, col);
        guiGraphics.fill(cx, cy - reach - 2, cx + 1, cy + reach + 3, col);
    }

    private void save() {
        String typed = this.hexBox.getValue().trim();
        if (!ColorUtil.isHexColor(typed)) {
            typed = ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness);
        }
        this.parent.onColorEdits(this.fullPath, typed);
        Minecraft.getInstance().setScreen((Screen)this.parent);
    }

    public void onClose() {
        Minecraft.getInstance().setScreen((Screen)this.parent);
    }

    private void onHue(float v) {
        this.hue = v;
        this.syncHex();
    }

    private void onSaturation(float v) {
        this.saturation = v;
        this.syncHex();
    }

    private void onBrightness(float v) {
        this.brightness = v;
        this.syncHex();
    }

    private void setHexSilently(String hex) {
        if (this.hexBox == null) {
            return;
        }
        this.suppressHexResponder = true;
        this.hexBox.setValue(hex);
        this.suppressHexResponder = false;
    }

    private void syncHex() {
        this.setHexSilently(ColorPickerScreen.hsvToHex(this.hue, this.saturation, this.brightness));
    }

    private void parseHex(String hex) {
        float[] hsv = ColorPickerScreen.argbToHSV(ColorUtil.hexToARGB(hex));
        this.hue = hsv[0];
        this.saturation = hsv[1];
        this.brightness = hsv[2];
    }

    private static String hsvToHex(float h, float s, float v) {
        int rgb = Color.HSBtoRGB(h, s, v) & 0xFFFFFF;
        return String.format("%06X", rgb);
    }

    private static int hsvToARGB(float h, float s, float v) {
        return 0xFF000000 | Color.HSBtoRGB(h, s, v) & 0xFFFFFF;
    }

    private static float[] argbToHSV(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return Color.RGBtoHSB(r, g, b, null);
    }

    private void clearHexFocusIfNotHovered(double mx, double my) {
        if (this.hexBox != null && !this.hexBox.isMouseOver(mx, my)) {
            this.hexBox.setFocused(false);
            if (this.getFocused() == this.hexBox) {
                this.setFocused(null);
            }
        }
    }

    private void onHexChanged(String raw) {
        if (this.suppressHexResponder) {
            return;
        }
        String typed = raw.trim().toUpperCase(Locale.ROOT);
        if (!typed.equals(raw)) {
            int cursor = this.hexBox.getCursorPosition();
            this.suppressHexResponder = true;
            this.hexBox.setValue(typed);
            this.hexBox.setCursorPosition(cursor);
            this.hexBox.setHighlightPos(cursor);
            this.suppressHexResponder = false;
        }
        if (ColorUtil.isHexColor(typed)) {
            int argb = ColorUtil.hexToARGB(typed);
            float[] hsv = ColorPickerScreen.argbToHSV(argb);
            float newH = hsv[0];
            float newS = hsv[1];
            float newV = hsv[2];
            this.saturation = newS;
            this.brightness = newV;
            if (newV > 0.003921569f && newS > 0.003921569f) {
                this.hue = newH;
            }
            this.hueSlider.setSilently(this.hue);
            this.saturationSlider.setSilently(this.saturation);
            this.brightnessSlider.setSilently(this.brightness);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class ColorSlider
    extends AbstractSliderButton {
        private final String label;
        private final Consumer<Float> onChange;

        ColorSlider(int x, int y, int w, int h, String label, float start, Consumer<Float> cb) {
            super(x, y, w, h, (Component)Component.literal((String)label), (double)start);
            this.label = label;
            this.onChange = cb;
            this.updateMessage();
        }

        protected void updateMessage() {
            this.setMessage((Component)Component.literal((String)(this.label + ": " + Math.round(this.value * 100.0) + "%")));
        }

        protected void applyValue() {
            this.onChange.accept(Float.valueOf((float)this.value));
            this.updateMessage();
        }

        void setSilently(float v) {
            this.value = v;
            this.updateMessage();
        }

        public boolean keyPressed(int key, int scan, int mods) {
            if (this.isFocused()) {
                if (key == 265) {
                    this.value = Mth.clamp((double)(this.value + (double)0.01f), (double)0.0, (double)1.0);
                    this.applyValue();
                    return true;
                }
                if (key == 264) {
                    this.value = Mth.clamp((double)(this.value - (double)0.01f), (double)0.0, (double)1.0);
                    this.applyValue();
                    return true;
                }
            }
            return super.keyPressed(key, scan, mods);
        }
    }
}

