/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.visibility;

import com.eruannie_9.booklinggear.screen.config.visibility.VisibilityRule;
import com.eruannie_9.booklinggear.screen.config.visibility.options.FunctionalVisibilityRule;
import com.eruannie_9.booklinggear.screen.config.visibility.options.MatchVisibilityRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public final class VisibilityChecker {
    private static final List<VisibilityRule> RULES = new ArrayList<VisibilityRule>();

    private VisibilityChecker() {
    }

    public static void register(VisibilityRule rule) {
        RULES.add(rule);
    }

    public static Condition when(ModConfigSpec.ConfigValue<?> controller, Object triggerValue) {
        return new Condition(controller, triggerValue);
    }

    public static CustomCondition when(BooleanSupplier condition) {
        return new CustomCondition(condition);
    }

    public static boolean isVisible(String fullPath, Map<String, Object> currentVals) {
        boolean visible = true;
        for (VisibilityRule r : RULES) {
            Boolean decision = r.isVisible(fullPath, currentVals);
            if (decision == null) continue;
            visible &= decision.booleanValue();
        }
        return visible;
    }

    public static final class Condition {
        private final ModConfigSpec.ConfigValue<?> controller;
        private final Object triggerValue;

        private Condition(ModConfigSpec.ConfigValue<?> controller, Object triggerValue) {
            this.controller = controller;
            this.triggerValue = triggerValue;
        }

        public void view(ModConfigSpec.ConfigValue<?> ... keepVisible) {
            ArrayList<String> paths = new ArrayList<String>();
            for (ModConfigSpec.ConfigValue<?> cv : keepVisible) {
                paths.add(String.join((CharSequence)".", cv.getPath()));
            }
            VisibilityChecker.register(new MatchVisibilityRule(this.controller, this.triggerValue, paths));
        }
    }

    public static final class CustomCondition {
        private final BooleanSupplier condition;

        private CustomCondition(BooleanSupplier condition) {
            this.condition = condition;
        }

        public void view(ModConfigSpec.ConfigValue<?> ... keepVisible) {
            List<String> paths = Arrays.stream(keepVisible).map(cv -> String.join((CharSequence)".", cv.getPath())).collect(Collectors.toList());
            VisibilityChecker.register(new FunctionalVisibilityRule(this.condition, paths));
        }
    }
}

