/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.visibility.animation;

import com.eruannie_9.booklinggear.screen.config.visibility.animation.AnimatedEntry;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ButtonList
extends AbstractSelectionList<Entry> {
    private static final int OFFSCREEN = 2000;

    public ButtonList(Minecraft minecraft, int width, int height, int topY, int itemHeight) {
        super(minecraft, width, height, topY, itemHeight);
    }

    public int getScrollbarX() {
        return this.width - 10;
    }

    public void addInstant(Button button) {
        Entry entry = new Entry(button);
        entry.setInstantState(true);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void tickAnimations() {
        boolean listChanged = false;
        Iterator it = this.children().iterator();
        while (it.hasNext()) {
            Entry entry = (Entry)((Object)it.next());
            entry.tickAnimator();
            if (entry.isTargetVisible() || !entry.isGone()) continue;
            it.remove();
            listChanged = true;
        }
        if (listChanged) {
            this.setScrollAmount(this.getScrollAmount());
        }
    }

    public int getRowWidth() {
        return (int)((double)this.width * 0.7);
    }

    protected int getScrollbarPosition() {
        return this.width + 2000;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int trackX = this.getScrollbarX();
        if (mouseX >= (double)trackX && mouseX <= (double)(trackX + 10)) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean isSelectedItem(int index) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Entry
    extends AnimatedEntry<Entry> {
        private final Button button;

        public Entry(Button button) {
            this.button = button;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int posX = x + (rowWidth - this.button.getWidth()) / 2;
            int posY = this.easedY(y);
            this.button.setX(posX);
            this.button.setY(posY);
            this.button.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int btn) {
            return this.button.mouseClicked(mouseX, mouseY, btn);
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

