/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.visibility.animation;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.util.Ease;
import net.minecraft.Util;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class VisibilityAnimator {
    private static final float DURATION = 1000.0f;
    private boolean targetVisible;
    private float progress;
    private long lastMs;

    public VisibilityAnimator(boolean initiallyVisible) {
        this.targetVisible = initiallyVisible;
        this.progress = initiallyVisible ? 1.0f : 0.0f;
        this.lastMs = Util.getMillis();
    }

    public void tick() {
        if (!((Boolean)ModConfiguration.ANIMATIONS_ENABLED.get()).booleanValue()) {
            this.progress = this.targetVisible ? 1.0f : 0.0f;
            this.lastMs = Util.getMillis();
            return;
        }
        long now = Util.getMillis();
        float dt = now - this.lastMs;
        this.lastMs = now;
        float speed = dt / 1000.0f;
        this.progress = this.targetVisible ? Math.min(1.0f, this.progress + speed) : Math.max(0.0f, this.progress - speed);
    }

    public float eased() {
        if (!((Boolean)ModConfiguration.ANIMATIONS_ENABLED.get()).booleanValue()) {
            return this.progress;
        }
        return this.targetVisible ? Ease.outCubic(this.progress) : Ease.inCubic(this.progress);
    }

    public void setInstantState(boolean visible) {
        this.targetVisible = visible;
        this.progress = visible ? 1.0f : 0.0f;
        this.lastMs = Util.getMillis();
    }

    public void restartFromHidden() {
        this.setInstantState(false);
        this.targetVisible = true;
    }

    public void setTargetVisible(boolean v) {
        this.targetVisible = v;
    }

    public boolean isTargetVisible() {
        return this.targetVisible;
    }

    public float progress() {
        return this.progress;
    }

    public boolean isGone() {
        return !this.targetVisible && this.progress <= 0.0f;
    }
}

