/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.visibility.options;

import com.eruannie_9.booklinggear.screen.config.visibility.VisibilityRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class MatchVisibilityRule
implements VisibilityRule {
    private final ModConfigSpec.ConfigValue<?> controller;
    private final Object triggerValue;
    private final Set<String> visiblePaths;
    private final Set<String> affectedFolders = new HashSet<String>();

    public MatchVisibilityRule(ModConfigSpec.ConfigValue<?> controller, Object triggerValue, Collection<String> visiblePaths) {
        this.controller = controller;
        this.triggerValue = triggerValue;
        this.visiblePaths = Set.copyOf(visiblePaths);
        this.affectedFolders.add(MatchVisibilityRule.firstSegment(String.join((CharSequence)".", controller.getPath())));
        for (String path : visiblePaths) {
            this.affectedFolders.add(MatchVisibilityRule.firstSegment(path));
        }
    }

    private static String firstSegment(String path) {
        int idx = path.indexOf(46);
        return idx < 0 ? path : path.substring(0, idx);
    }

    @Override
    @Nullable
    public Boolean isVisible(String fullPath, Map<String, Object> currentValues) {
        boolean manageThisEntry;
        if (!this.affectedFolders.contains(MatchVisibilityRule.firstSegment(fullPath))) {
            return null;
        }
        String ctrlPath = String.join((CharSequence)".", this.controller.getPath());
        if (fullPath.equals(ctrlPath)) {
            return Boolean.TRUE;
        }
        boolean manageAllInFolder = this.visiblePaths.isEmpty();
        boolean bl = manageThisEntry = manageAllInFolder || this.visiblePaths.contains(fullPath);
        if (!manageThisEntry) {
            return null;
        }
        Object liveVal = currentValues.getOrDefault(ctrlPath, this.controller.get());
        return Objects.equals(liveVal, this.triggerValue);
    }
}

