/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.warning;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public final class JsonWarningList {
    private static final String KEY_COMMENT = "_comment";
    private static final String KEY_SEEN = "seen";
    private static final Set<String> SEEN = new HashSet<String>();
    private static final Path FILE = FMLPaths.CONFIGDIR.get().resolve("booklinggear_warning_data.json");
    private static final Type TYPE_SET = new TypeToken<Set<String>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<String> COMMENT_LINES = List.of("BooklingGear warning tracker.", "Stores config warnings you\u2019ve confirmed.", "Each entry in \u201cseen\u201d is an internal warning ID.", "Remove IDs or delete this file to restore the warnings.", "This file holds no game progress, settings, or personal data.");

    private JsonWarningList() {
    }

    public static boolean isSeen(String id) {
        return SEEN.contains(id);
    }

    public static boolean hasWarnings() {
        return !SEEN.isEmpty();
    }

    public static void markSeen(String id) {
        if (SEEN.add(id)) {
            JsonWarningList.save();
        }
    }

    public static void reset() {
        SEEN.clear();
        JsonWarningList.save();
    }

    public static void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            return;
        }
        try (BufferedReader rd = Files.newBufferedReader(FILE);){
            JsonElement root = JsonParser.parseReader((Reader)rd);
            if (root.isJsonObject() && root.getAsJsonObject().has(KEY_SEEN)) {
                JsonWarningList.addAll(root.getAsJsonObject().getAsJsonArray(KEY_SEEN));
            } else if (root.isJsonArray()) {
                JsonWarningList.addAll(root.getAsJsonArray());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void save() {
        JsonObject out = new JsonObject();
        JsonArray commentArr = new JsonArray();
        COMMENT_LINES.forEach(arg_0 -> ((JsonArray)commentArr).add(arg_0));
        out.add(KEY_COMMENT, (JsonElement)commentArr);
        out.add(KEY_SEEN, GSON.toJsonTree(SEEN, TYPE_SET));
        try (BufferedWriter wr = Files.newBufferedWriter(FILE, new OpenOption[0]);){
            GSON.toJson((JsonElement)out, (Appendable)wr);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addAll(JsonArray arr) {
        for (JsonElement e : arr) {
            if (!e.isJsonPrimitive() || !e.getAsJsonPrimitive().isString()) continue;
            SEEN.add(e.getAsString());
        }
    }
}

