/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.warning;

import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class WarningScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private final Runnable onConfirm;
    private final Runnable onCancel;
    private final List<Component> warnings = new ArrayList<Component>();
    private final List<List<FormattedCharSequence>> pages = new ArrayList<List<FormattedCharSequence>>();
    private int currentPage;
    private Button btnPrev;
    private Button btnNext;
    private Button btnSave;
    private Button btnCancel;
    private int titleY;
    private int textStartY;
    private int buttonsY;
    private AnimatedScreenTitle glintTitle;

    public WarningScreen(List<Component> messages, Runnable onConfirm, Runnable onCancel) {
        super((Component)Component.literal((String)"Warning"));
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        this.warnings.addAll(new LinkedHashSet<Component>(messages));
    }

    protected void init() {
        super.init();
        int wrapWidth = (int)((float)this.width * 0.8f);
        for (Component c : this.warnings) {
            this.pages.add(this.font.split((FormattedText)c, wrapWidth));
        }
        this.btnPrev = Button.builder((Component)Component.literal((String)"<"), b -> this.changePage(-1)).pos(0, 0).size(20, 20).build();
        this.btnNext = Button.builder((Component)Component.literal((String)">"), b -> this.changePage(1)).pos(0, 0).size(20, 20).build();
        this.btnSave = Button.builder((Component)Component.literal((String)"Save"), b -> this.onConfirm.run()).pos(0, 0).size(80, 20).build();
        this.btnCancel = Button.builder((Component)Component.literal((String)"Cancel"), b -> this.onCancel.run()).pos(0, 0).size(80, 20).build();
        this.addRenderableWidget((GuiEventListener)this.btnPrev);
        this.addRenderableWidget((GuiEventListener)this.btnNext);
        this.addRenderableWidget((GuiEventListener)this.btnSave);
        this.addRenderableWidget((GuiEventListener)this.btnCancel);
        if (this.glintTitle == null) {
            this.glintTitle = new AnimatedScreenTitle(this.title.getString());
        }
        this.recalcLayout();
    }

    private void changePage(int delta) {
        int next = this.currentPage + delta;
        if (next >= 0 && next < this.warnings.size()) {
            this.currentPage = next;
            this.recalcLayout();
        }
    }

    private void recalcLayout() {
        int n;
        Objects.requireNonNull(this.font);
        int titleHeight = 9;
        int gapAfterTitle = 10;
        int gapBeforeBtns = 20;
        if (this.pages.isEmpty()) {
            n = 0;
        } else {
            int n2 = this.pages.get(this.currentPage).size();
            Objects.requireNonNull(this.font);
            n = n2 * 9;
        }
        int textHeight = n;
        int totalHeight = titleHeight + gapAfterTitle + textHeight + gapBeforeBtns + 20;
        this.titleY = Math.max(10, (this.height - totalHeight) / 2);
        this.textStartY = this.titleY + titleHeight + gapAfterTitle;
        this.buttonsY = this.textStartY + textHeight + gapBeforeBtns;
        this.positionButtons();
    }

    private void positionButtons() {
        boolean multi;
        int arrowW = 20;
        int gap = 10;
        int saveW = 80;
        int cancelW = 80;
        this.btnPrev.visible = multi = this.warnings.size() > 1;
        this.btnNext.visible = multi;
        this.btnPrev.active = this.currentPage > 0;
        this.btnNext.active = this.currentPage < this.warnings.size() - 1;
        int totalW = (multi ? 30 : 0) + 80 + 10 + 80 + (multi ? 30 : 0);
        int startX = (this.width - totalW) / 2;
        if (multi) {
            this.btnPrev.setX(startX);
            this.btnPrev.setY(this.buttonsY);
            startX += 30;
        }
        this.btnSave.setX(startX);
        this.btnSave.setY(this.buttonsY);
        this.btnCancel.setX(startX += 90);
        this.btnCancel.setY(this.buttonsY);
        if (multi) {
            this.btnNext.setX(startX += 90);
            this.btnNext.setY(this.buttonsY);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.glintTitle.render(guiGraphics, this.font, this.width);
        if (!this.pages.isEmpty()) {
            int y = this.textStartY;
            for (FormattedCharSequence line : this.pages.get(this.currentPage)) {
                int lineW = this.font.width(line);
                guiGraphics.drawString(this.font, line, (this.width - lineW) / 2, y, 0xFFFFFF, false);
                Objects.requireNonNull(this.font);
                y += 9;
            }
        }
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

