/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.warning.options;

import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ModConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractWarningOption<T> {
    private final String id;
    private final ModConfigSpec.ConfigValue<T> value;
    private final Component message;

    protected AbstractWarningOption(ModConfigSpec.ConfigValue<T> value, Component message) {
        this(AbstractWarningOption.generateId(value, message), value, message);
    }

    protected AbstractWarningOption(String id, ModConfigSpec.ConfigValue<T> value, Component message) {
        this.id = id;
        this.value = value;
        this.message = message;
    }

    public String id() {
        return this.id;
    }

    public ModConfigSpec.ConfigValue<T> configValue() {
        return this.value;
    }

    public Component warningMessage() {
        return this.message;
    }

    public boolean isSeen() {
        return JsonWarningList.isSeen(this.id);
    }

    public void markSeen() {
        JsonWarningList.markSeen(this.id);
    }

    public abstract boolean shouldConfirm(Object var1);

    private static String generateId(ModConfigSpec.ConfigValue<?> v, Component msg) {
        String base = String.join((CharSequence)".", v.getPath()) + "|" + msg.getString();
        return UUID.nameUUIDFromBytes(base.getBytes(StandardCharsets.UTF_8)).toString();
    }
}

