/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.list;

import com.eruannie_9.booklinggear.screen.config.visibility.animation.AnimatedEntry;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class EntryList
extends AbstractSelectionList<Entry> {
    private static final int OFFSCREEN = 2000;

    public EntryList(Minecraft minecraft, int width, int height, int top, int rowHeight) {
        super(minecraft, width, height, top, rowHeight);
    }

    public void addEntryInstant(Entry entry) {
        entry.setInstantState(true);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void addEntryAnimated(Entry entry) {
        entry.setInstantState(false);
        entry.setTargetVisible(true);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    public void removeEntryAnimated(Entry entry) {
        entry.setTargetVisible(false);
    }

    public void tickAnimations() {
        boolean listChanged = false;
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)((Object)iterator.next());
            entry.tickAnimator();
            if (entry.isTargetVisible() || !entry.isGone()) continue;
            iterator.remove();
            listChanged = true;
        }
        if (listChanged) {
            this.setScrollAmount(this.getScrollAmount());
        }
    }

    public int getRowWidth() {
        return (int)((double)this.width * 0.8);
    }

    public int getScrollbarX() {
        return this.width - 10;
    }

    protected int getScrollbarPosition() {
        return this.width + 2000;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        Entry row = (Entry)this.getEntryAtPosition(mouseX, mouseY);
        if (row != null && row.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)row);
            this.setDragging(true);
            return true;
        }
        return false;
    }

    protected boolean isSelectedItem(int index) {
        return false;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Entry
    extends AnimatedEntry<Entry> {
        private final EntryList parentList;
        private final EditBox textBox;
        private final Button deleteButton;

        public Entry(EntryList parentList, String value) {
            this.parentList = parentList;
            int rowWidth = parentList.getRowWidth();
            int textBoxWidth = rowWidth - 25;
            int textBoxX = (parentList.width - rowWidth) / 2;
            this.textBox = new EditBox(Minecraft.getInstance().font, textBoxX, 0, textBoxWidth, 20, (Component)Component.empty());
            this.textBox.setMaxLength(512);
            this.textBox.setValue(value);
            this.deleteButton = Button.builder((Component)Component.literal((String)"x"), b -> parentList.removeEntryAnimated(this)).pos(0, 0).size(20, 20).build();
        }

        public String getValue() {
            return this.textBox.getValue().trim();
        }

        public void setValue(String value) {
            this.textBox.setValue(value);
        }

        public void setFocused(boolean f) {
            this.textBox.setFocused(f);
        }

        public EditBox getTextBox() {
            return this.textBox;
        }

        public void render(@NotNull GuiGraphics guiGraphics, int index, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int slideOffset = this.isTargetVisible() ? this.slideX(rowWidth) : -Mth.ceil((float)((1.0f - this.easedProgress()) * (float)this.parentList.width));
            int adjustedY = this.easedY(yPos);
            this.textBox.setX(xPos + slideOffset);
            this.textBox.setY(adjustedY);
            this.textBox.setWidth(rowWidth - 25);
            this.deleteButton.setX(this.textBox.getX() + this.textBox.getWidth() + 5);
            this.deleteButton.setY(adjustedY);
            this.textBox.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean used = false;
            if (this.textBox.isMouseOver(mouseX, mouseY)) {
                used = this.textBox.mouseClicked(mouseX, mouseY, button);
                this.parentList.setFocused((GuiEventListener)this);
                this.parentList.setDragging(true);
                this.parentList.children().forEach(e -> e.textBox.setFocused(false));
                this.textBox.setFocused(true);
                Objects.requireNonNull(Minecraft.getInstance().screen).setFocused((GuiEventListener)this.textBox);
            } else {
                this.textBox.setFocused(false);
            }
            if (this.deleteButton.isMouseOver(mouseX, mouseY)) {
                used |= this.deleteButton.mouseClicked(mouseX, mouseY, button);
            }
            return used;
        }

        public boolean charTyped(char character, int modifiers) {
            return this.textBox.isFocused() && this.textBox.charTyped(character, modifiers);
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            return this.textBox.isFocused() && this.textBox.keyPressed(keyCode, scanCode, modifiers);
        }

        @NotNull
        public Component getNarration() {
            return Component.empty();
        }
    }
}

