/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.list;

import com.eruannie_9.booklinggear.screen.config.ConfigScreen;
import com.eruannie_9.booklinggear.screen.config.visibility.animation.AnimatedEntry;
import com.eruannie_9.booklinggear.screen.list.EntryList;
import com.eruannie_9.booklinggear.util.scroll.ScrollSlider;
import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class ListEditScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private final ConfigScreen parentScreen;
    private final String fullPath;
    private final List<String> valueList;
    private EntryList entryList;
    private AnimatedScreenTitle animatedTitle;

    public ListEditScreen(ConfigScreen parentScreen, String title, String fullPath, List<String> initialValues) {
        super((Component)Component.literal((String)("Edit " + title)));
        this.parentScreen = parentScreen;
        this.fullPath = fullPath;
        this.valueList = new ArrayList<String>(initialValues);
    }

    protected void init() {
        int listTop = 40;
        int listBottom = this.height - 80;
        int listHeight = listBottom - listTop;
        this.entryList = new EntryList(this.minecraft, this.width, listHeight, listTop, 24);
        this.addRenderableWidget((GuiEventListener)this.entryList);
        this.addRenderableWidget((GuiEventListener)ScrollSlider.attach(this.entryList).widget());
        for (String v : this.valueList) {
            this.entryList.addEntryInstant(new EntryList.Entry(this.entryList, v));
        }
        int buttonWidth = 100;
        int gap = 10;
        int centerX = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Add"), btn -> this.entryList.addEntryAnimated(new EntryList.Entry(this.entryList, ""))).pos(centerX - buttonWidth - gap / 2, this.height - 70).size(buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Save"), btn -> this.saveAndClose()).pos(centerX + gap / 2, this.height - 70).size(buttonWidth, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"Cancel"), btn -> this.minecraft.setScreen((Screen)this.parentScreen)).pos(centerX - buttonWidth / 2, this.height - 40).size(buttonWidth, 20).build());
        if (this.animatedTitle == null) {
            this.animatedTitle = new AnimatedScreenTitle(this.title.getString());
        }
    }

    private void saveAndClose() {
        List<String> newList = this.entryList.children().stream().filter(AnimatedEntry::isTargetVisible).map(EntryList.Entry::getValue).filter(s -> !s.isEmpty()).toList();
        this.parentScreen.onListEdits(this.fullPath, newList);
        Objects.requireNonNull(this.minecraft).setScreen((Screen)this.parentScreen);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.entryList.tickAnimations();
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.animatedTitle.render(guiGraphics, this.font, this.width);
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void resize(@NotNull Minecraft mc, int newWidth, int newHeight) {
        double scrollRatio = this.entryList != null && this.entryList.getMaxScroll() > 0 ? this.entryList.getScrollAmount() / (double)this.entryList.getMaxScroll() : 0.0;
        List<String> liveLines = Objects.requireNonNull(this.entryList).children().stream().filter(AnimatedEntry::isTargetVisible).map(EntryList.Entry::getValue).toList();
        this.valueList.clear();
        this.valueList.addAll(liveLines);
        super.resize(mc, newWidth, newHeight);
        if (this.entryList != null && this.entryList.getMaxScroll() > 0) {
            this.entryList.setScrollAmount(scrollRatio * (double)this.entryList.getMaxScroll());
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean handled = this.entryList.mouseClicked(mouseX, mouseY, button);
        if (!handled) {
            handled = super.mouseClicked(mouseX, mouseY, button);
        }
        if (button == 0) {
            boolean overEditBox = this.entryList.children().stream().anyMatch(e -> e.getTextBox().isMouseOver(mouseX, mouseY));
            if (overEditBox) {
                for (EntryList.Entry e2 : this.entryList.children()) {
                    if (!e2.getTextBox().isFocused()) continue;
                    this.setFocused((GuiEventListener)e2.getTextBox());
                    break;
                }
            } else {
                this.entryList.children().forEach(e -> e.getTextBox().setFocused(false));
                this.setFocused(null);
            }
        }
        return handled;
    }
}

