/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.update;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.eruannie_9.booklinggear.update.UpdateMode;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="booklinggear", value={Dist.CLIENT})
public final class UpdateAnnouncer {
    private static final Map<String, Entry> PENDING = new LinkedHashMap<String, Entry>();
    private static boolean announcedThisSession = false;

    private UpdateAnnouncer() {
    }

    public static synchronized void queue(String modId, String displayName, String latest, String current, String url) {
        PENDING.put(modId, new Entry(displayName, latest, current, url));
    }

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        UpdateAnnouncer.announce();
    }

    private static synchronized void announce() {
        UpdateMode mode = (UpdateMode)((Object)ModConfiguration.MOD_UPDATES.get());
        if (mode == UpdateMode.NONE) {
            return;
        }
        if (mode == UpdateMode.SESSION && announcedThisSession) {
            return;
        }
        if (PENDING.isEmpty()) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        int count = PENDING.size();
        if (count > 1) {
            Objects.requireNonNull(player).sendSystemMessage((Component)Component.literal((String)"New updates available:").withStyle(ChatFormatting.GOLD));
        }
        if (count == 1) {
            Entry entry2 = PENDING.values().iterator().next();
            Objects.requireNonNull(player).sendSystemMessage((Component)UpdateAnnouncer.singleLine(entry2));
        } else {
            PENDING.values().forEach(entry -> player.sendSystemMessage((Component)UpdateAnnouncer.bulletLine(entry)));
        }
        if (mode == UpdateMode.SESSION) {
            announcedThisSession = true;
        }
    }

    private static MutableComponent singleLine(Entry entry) {
        MutableComponent intro = Component.literal((String)"New update available: ").withStyle(ChatFormatting.GOLD);
        return Component.empty().append((Component)intro).append((Component)UpdateAnnouncer.nameStyled(entry.name())).append(" ").append((Component)UpdateAnnouncer.versionPair(entry)).append((Component)UpdateAnnouncer.downloadButton(entry.url()));
    }

    private static MutableComponent bulletLine(Entry entry) {
        return Component.literal((String)" \u2022 ").append((Component)UpdateAnnouncer.nameStyled(entry.name())).append(" ").append((Component)UpdateAnnouncer.versionPair(entry)).append((Component)UpdateAnnouncer.downloadButton(entry.url()));
    }

    private static MutableComponent nameStyled(String name) {
        return Component.literal((String)name).withStyle(ChatFormatting.AQUA);
    }

    private static MutableComponent versionPair(Entry entry) {
        MutableComponent current = Component.literal((String)entry.current()).withStyle(ChatFormatting.RED);
        MutableComponent arrow = Component.literal((String)" \u2192 ").withStyle(ChatFormatting.GRAY);
        MutableComponent latest = Component.literal((String)entry.latest()).withStyle(ChatFormatting.GREEN);
        return Component.empty().append((Component)current).append((Component)arrow).append((Component)latest);
    }

    private static MutableComponent downloadButton(String url) {
        return Component.literal((String)" [Download]").withStyle(style -> style.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open CurseForge page"))));
    }

    private record Entry(String name, String latest, String current, String url) {
    }
}

