/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CommentText {
    private static final Pattern URL_PATTERN = Pattern.compile("(https?://\\S+)", 2);
    private static final String TRAILING_PUNCT = ".,;)]}>\"'";
    private static final Component NO_DESC = Component.literal((String)"No description available.");

    private CommentText() {
    }

    public static List<Component> toTooltipComponents(String text) {
        ArrayList<Component> out = new ArrayList<Component>();
        if (text == null || text.trim().isEmpty()) {
            out.add(NO_DESC);
            return out;
        }
        for (String line : text.split("\n")) {
            MutableComponent styled = Component.empty();
            Matcher m = URL_PATTERN.matcher(line);
            int last = 0;
            while (m.find()) {
                if (m.start() > last) {
                    styled.append((Component)Component.literal((String)line.substring(last, m.start())));
                }
                String matched = m.group(1);
                String trimmed = CommentText.trimTrailingPunctuation(matched);
                String trailing = matched.substring(trimmed.length());
                styled.append((Component)Component.literal((String)trimmed).withStyle(s -> s.withColor(ChatFormatting.BLUE).withUnderlined(Boolean.valueOf(true))));
                if (!trailing.isEmpty()) {
                    styled.append((Component)Component.literal((String)trailing));
                }
                last = m.end();
            }
            if (last < line.length()) {
                styled.append((Component)Component.literal((String)line.substring(last)));
            }
            out.add((Component)styled);
        }
        return out;
    }

    public static List<String> extractLinks(String text) {
        if (text == null || text.trim().isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> unique = new LinkedHashSet<String>();
        Matcher m = URL_PATTERN.matcher(text);
        while (m.find()) {
            unique.add(CommentText.trimTrailingPunctuation(m.group(1)));
        }
        return new ArrayList<String>(unique);
    }

    public static void openUrl(String url) {
        try {
            Util.getPlatform().openUri(new URI(url));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String trimTrailingPunctuation(String s) {
        int end;
        for (end = s.length(); end > 0 && TRAILING_PUNCT.indexOf(s.charAt(end - 1)) >= 0; --end) {
        }
        return s.substring(0, end);
    }
}

