/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MirroredImageButton
extends Button {
    private final ResourceLocation originalTexture;
    private final ResourceLocation mirroredTexture;
    private final ResourceLocation overlayTexture;
    private final int u;
    private final int v;
    private final int hoveredVOffset;
    private final int textureWidth;
    private final int textureHeight;
    private final boolean mirrorTexture;

    public MirroredImageButton(int x, int y, int width, int height, int u, int v, int hoveredVOffset, ResourceLocation texture, int textureWidth, int textureHeight, Button.OnPress onPress, Component message, boolean mirrorTexture, ResourceLocation overlayTexture) {
        super(x, y, width, height, message, onPress, Button.DEFAULT_NARRATION);
        this.u = u;
        this.v = v;
        this.hoveredVOffset = hoveredVOffset;
        this.originalTexture = texture;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.mirrorTexture = mirrorTexture;
        this.overlayTexture = overlayTexture;
        this.mirroredTexture = mirrorTexture ? this.createMirroredTexture(texture) : texture;
        this.setTooltip(Tooltip.create((Component)message));
    }

    private ResourceLocation createMirroredTexture(ResourceLocation texture) {
        ResourceLocation resourceLocation;
        block11: {
            Minecraft mc = Minecraft.getInstance();
            ResourceLocation mirroredTextureLocation = texture.withSuffix("_mirrored");
            Optional resourceOpt = mc.getResourceManager().getResource(texture);
            if (resourceOpt.isEmpty()) {
                throw new IOException("Resource not found: " + String.valueOf(texture));
            }
            Resource resource = (Resource)resourceOpt.get();
            InputStream in = resource.open();
            try {
                NativeImage originalImage = NativeImage.read((InputStream)in);
                NativeImage mirroredImage = new NativeImage(originalImage.getWidth(), originalImage.getHeight(), true);
                for (int y = 0; y < originalImage.getHeight(); ++y) {
                    for (int x = 0; x < originalImage.getWidth(); ++x) {
                        mirroredImage.setPixelRGBA(originalImage.getWidth() - x - 1, y, originalImage.getPixelRGBA(x, y));
                    }
                }
                mc.getTextureManager().register(mirroredTextureLocation, (AbstractTexture)new DynamicTexture(mirroredImage));
                originalImage.close();
                resourceLocation = mirroredTextureLocation;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return texture;
                }
            }
            in.close();
        }
        return resourceLocation;
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation textureToUse = this.mirrorTexture ? this.mirroredTexture : this.originalTexture;
        int yOffset = this.v;
        if (!this.active) {
            yOffset += this.hoveredVOffset * 2;
        } else if (this.isHoveredOrFocused()) {
            yOffset += this.hoveredVOffset;
        }
        guiGraphics.blit(textureToUse, this.getX(), this.getY(), (float)this.u, (float)yOffset, this.width, this.height, this.textureWidth, this.textureHeight);
        if (this.overlayTexture != null) {
            int overlayX = this.getX() + (this.mirrorTexture ? 3 : 0);
            int overlayY = this.getY();
            int overlayVOffset = 0;
            if (!this.active) {
                overlayVOffset += this.hoveredVOffset * 2;
            } else if (this.isHoveredOrFocused()) {
                overlayVOffset += this.hoveredVOffset;
            }
            guiGraphics.blit(this.overlayTexture, overlayX, overlayY, 0.0f, (float)overlayVOffset, this.width, this.height, this.textureWidth, this.textureHeight);
        }
    }
}

