/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TabWidget
extends Button {
    private static final Map<String, Float> SCALE_CACHE = new HashMap<String, Float>();
    public static final SoundPlayStrategy ONLY_IF_NOT_SELECTED = tab -> !tab.isSelected();
    private static final int TAB_TEXTURE_WIDTH = 69;
    private static final int TAB_TEXTURE_HEIGHT = 22;
    private final Screen parentScreen;
    private final Supplier<Boolean> selectedSupplier;
    private final Supplier<ItemStack> iconSupplier;
    private final Supplier<ResourceLocation> pictureSupplier;
    private final ResourceLocation texture;
    private final boolean animation;
    private final float animationSpeed;
    private final float baseScale;
    private final float hoverScale;
    private float currentScale;
    private final boolean usePicture;
    private final String tabId;
    private final boolean showTooltip;
    @Nullable
    private final SoundEvent clickSound;
    @Nullable
    private final SoundPlayStrategy soundPlayStrategy;

    public static void clearScaleCache() {
        SCALE_CACHE.clear();
    }

    public TabWidget(Screen parentScreen, int x, int y, int width, int height, Component title, @NotNull Supplier<Boolean> selectedSupplier, @NotNull Button.OnPress onPress, @NotNull Supplier<ItemStack> iconSupplier, @NotNull Supplier<ResourceLocation> pictureSupplier, float baseScale, float hoverScale, float animationSpeed, boolean animation, @NotNull ResourceLocation tabTexture, @Nullable SoundEvent clickSound, boolean showTooltip, @Nullable SoundPlayStrategy soundPlayStrategy) {
        super(x, y, width, height, title, onPress, Supplier::get);
        this.parentScreen = parentScreen;
        this.showTooltip = showTooltip;
        this.selectedSupplier = selectedSupplier;
        this.iconSupplier = iconSupplier;
        this.pictureSupplier = pictureSupplier;
        this.baseScale = baseScale;
        this.hoverScale = hoverScale;
        this.animationSpeed = animationSpeed;
        this.animation = animation;
        this.texture = tabTexture;
        this.clickSound = clickSound;
        this.soundPlayStrategy = soundPlayStrategy;
        this.tabId = title.getString();
        this.usePicture = this.pictureSupplier.get() != null;
        boolean initialSelected = this.selectedSupplier.get();
        this.currentScale = SCALE_CACHE.computeIfAbsent(this.tabId, k -> Float.valueOf(initialSelected ? hoverScale : baseScale)).floatValue();
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean selected;
        this.isHovered = this.isMouseOver(mouseX, mouseY);
        if (!this.isHovered) {
            this.setFocused(false);
        }
        int stateIndex = (selected = this.isSelected()) ? 1 : (this.isHoveredOrFocused() ? 2 : 0);
        int u = stateIndex * 23;
        boolean v = false;
        guiGraphics.blit(this.texture, this.getX(), this.getY(), this.width, this.height, (float)u, (float)v, this.width, this.height, 69, 22);
        float targetScale = !selected && !this.isHoveredOrFocused() ? this.baseScale : this.hoverScale;
        this.currentScale = this.animation ? Mth.lerp((float)this.animationSpeed, (float)this.currentScale, (float)targetScale) : targetScale;
        SCALE_CACHE.put(this.tabId, Float.valueOf(this.currentScale));
        int centerX = this.getX() + 11;
        int centerY = this.getY() + 11;
        if (this.usePicture) {
            ResourceLocation currentPic = this.pictureSupplier.get();
            if (currentPic != null) {
                this.renderPicture(guiGraphics, currentPic, centerX, centerY, this.currentScale);
            }
        } else {
            ItemStack currentIcon = this.iconSupplier.get();
            if (!currentIcon.isEmpty()) {
                this.renderItem(guiGraphics, currentIcon, centerX, centerY, this.currentScale, 12.0f);
            }
        }
        if (this.showTooltip && this.isHoveredOrFocused() && this.parentScreen != null) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, this.getMessage(), mouseX, mouseY);
        }
    }

    public void onPress() {
        super.onPress();
        this.setFocused(false);
    }

    public void playDownSound(@NotNull SoundManager soundManager) {
        if (this.soundPlayStrategy != null) {
            if (this.soundPlayStrategy.shouldPlaySound(this)) {
                this.playClickSound(soundManager);
            }
        } else {
            this.playClickSound(soundManager);
        }
    }

    private void playClickSound(@NotNull SoundManager soundManager) {
        if (this.clickSound != null) {
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)this.clickSound, (float)1.0f));
        } else {
            super.playDownSound(soundManager);
        }
    }

    public boolean isSelected() {
        return this.selectedSupplier.get();
    }

    private void renderItem(GuiGraphics guiGraphics, ItemStack stack, int x, int y, float scale, float size) {
        if (stack.isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        float sizeRatio = size / 16.0f;
        float finalScale = sizeRatio * scale;
        poseStack.translate((float)x, (float)y, 100.0f);
        poseStack.scale(finalScale, finalScale, finalScale);
        int offset = 8;
        guiGraphics.renderItem(stack, -offset, -offset);
        poseStack.popPose();
    }

    private void renderPicture(GuiGraphics guiGraphics, ResourceLocation pic, int centerX, int centerY, float scale) {
        int imgW = 17;
        int imgH = 16;
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)centerX - (double)((float)imgW * scale) / 2.0, (double)centerY - (double)((float)imgH * scale) / 2.0, 100.0);
        poseStack.scale(scale, scale, scale);
        guiGraphics.blit(pic, 0, 0, 0.0f, 0.0f, imgW, imgH, imgW, imgH);
        poseStack.popPose();
    }

    public static List<TabWidget> createTabsFromPictureData(Screen parentScreen, int bgLeft, int bgTop, int bgWidth, List<TabPictureData> dataList, ResourceLocation tabTexture, boolean animation, boolean showTooltip, Function<TabPictureData, SoundPlayStrategy> soundStrategyMapper) {
        ArrayList<TabWidget> widgets = new ArrayList<TabWidget>();
        int startY = bgTop + 5;
        int xPos = bgLeft + bgWidth;
        for (int i = 0; i < dataList.size(); ++i) {
            TabPictureData d = dataList.get(i);
            int yPos = startY + i * 24;
            SoundPlayStrategy strategy = soundStrategyMapper.apply(d);
            TabWidget widget = new Builder(parentScreen, xPos, yPos, 23, 22, (Component)Component.literal((String)d.label()), d.onPress(), d.selected()).pictureSupplier(d.picture()).baseScale(d.baseScale()).hoverScale(d.hoverScale()).animationSpeed(d.animationSpeed()).animation(animation).tabTexture(tabTexture).clickSound(d.clickSound()).showTooltip(showTooltip).soundPlayStrategy(strategy).build();
            widgets.add(widget);
        }
        return widgets;
    }

    public static List<TabWidget> createTabsFromItemData(Screen parentScreen, int bgLeft, int bgTop, int bgWidth, List<TabItemData> dataList, ResourceLocation tabTexture, boolean animation, boolean showTooltip, Function<TabItemData, SoundPlayStrategy> soundStrategyMapper) {
        ArrayList<TabWidget> widgets = new ArrayList<TabWidget>();
        int startY = bgTop + 5;
        int xPos = bgLeft + bgWidth;
        for (int i = 0; i < dataList.size(); ++i) {
            TabItemData d = dataList.get(i);
            int yPos = startY + i * 24;
            SoundPlayStrategy strategy = soundStrategyMapper.apply(d);
            TabWidget widget = new Builder(parentScreen, xPos, yPos, 23, 22, (Component)Component.literal((String)d.label()), d.onPress(), d.selected()).iconSupplier(d.icon()).baseScale(d.baseScale()).hoverScale(d.hoverScale()).animationSpeed(d.animationSpeed()).animation(animation).tabTexture(tabTexture).clickSound(d.clickSound()).showTooltip(showTooltip).soundPlayStrategy(strategy).build();
            widgets.add(widget);
        }
        return widgets;
    }

    @FunctionalInterface
    public static interface SoundPlayStrategy {
        public boolean shouldPlaySound(TabWidget var1);
    }

    public record TabPictureData(String label, Supplier<Boolean> selected, Button.OnPress onPress, Supplier<ResourceLocation> picture, float baseScale, float hoverScale, float animationSpeed, @Nullable SoundEvent clickSound) {
    }

    public static class Builder {
        private final Screen parentScreen;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Component title;
        private final Button.OnPress onPress;
        private final Supplier<Boolean> selectedSupplier;
        private Supplier<ItemStack> iconSupplier = () -> ItemStack.EMPTY;
        private Supplier<ResourceLocation> pictureSupplier = () -> null;
        private float baseScale = 1.0f;
        private float hoverScale = 1.25f;
        private float animationSpeed = 0.1f;
        private boolean animation = true;
        private ResourceLocation tabTexture = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/widgets.png");
        private boolean showTooltip = true;
        private SoundEvent clickSound = null;
        private SoundPlayStrategy soundPlayStrategy = null;

        public Builder(Screen parentScreen, int x, int y, int width, int height, Component title, Button.OnPress onPress, Supplier<Boolean> selectedSupplier) {
            this.parentScreen = parentScreen;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.title = title;
            this.onPress = onPress;
            this.selectedSupplier = selectedSupplier;
        }

        public Builder iconSupplier(Supplier<ItemStack> iconSupplier) {
            this.iconSupplier = iconSupplier;
            return this;
        }

        public Builder pictureSupplier(Supplier<ResourceLocation> pictureSupplier) {
            this.pictureSupplier = pictureSupplier;
            return this;
        }

        public Builder baseScale(float baseScale) {
            this.baseScale = baseScale;
            return this;
        }

        public Builder hoverScale(float hoverScale) {
            this.hoverScale = hoverScale;
            return this;
        }

        public Builder animationSpeed(float animationSpeed) {
            this.animationSpeed = animationSpeed;
            return this;
        }

        public Builder animation(boolean animation) {
            this.animation = animation;
            return this;
        }

        public Builder tabTexture(ResourceLocation texture) {
            this.tabTexture = texture;
            return this;
        }

        public Builder showTooltip(boolean showTooltip) {
            this.showTooltip = showTooltip;
            return this;
        }

        public Builder clickSound(SoundEvent clickSound) {
            this.clickSound = clickSound;
            return this;
        }

        public Builder soundPlayStrategy(SoundPlayStrategy strategy) {
            this.soundPlayStrategy = strategy;
            return this;
        }

        public TabWidget build() {
            return new TabWidget(this.parentScreen, this.x, this.y, this.width, this.height, this.title, this.selectedSupplier, this.onPress, this.iconSupplier, this.pictureSupplier, this.baseScale, this.hoverScale, this.animationSpeed, this.animation, this.tabTexture, this.clickSound, this.showTooltip, this.soundPlayStrategy);
        }
    }

    public record TabItemData(String label, Supplier<Boolean> selected, Button.OnPress onPress, Supplier<ItemStack> icon, float baseScale, float hoverScale, float animationSpeed, @Nullable SoundEvent clickSound) {
    }
}

