/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util.scroll;

import com.eruannie_9.booklinggear.ModConfiguration;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class ScrollSlider {
    private static final int BAR_WIDTH = 6;
    private static final int MIN_KNOB_HEIGHT = 12;
    private static final int RIGHT_PADDING = 4;
    private static final int TRACK_COLOR = -16777216;
    private static final int BODY_COLOR = -8355712;
    private static final int HIGHLIGHT_COLOR = -4144960;
    private static final int SHADOW_COLOR = -12566464;
    private static final int BODY_HOVER_COLOR = -5921371;
    private final Knob sliderKnob;

    private ScrollSlider(AbstractSelectionList<?> targetList) {
        this.sliderKnob = new Knob(targetList);
    }

    public static ScrollSlider attach(AbstractSelectionList<?> targetList) {
        return new ScrollSlider(targetList);
    }

    public Knob widget() {
        return this.sliderKnob;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Knob
    extends AbstractWidget {
        private static final double SMOOTHING_TAU_SEC = 0.15;
        private final AbstractSelectionList<?> parentList;
        private boolean dragging;
        private double dragOffsetPx;
        private double smoothedHeight;
        private long lastFrameMillis;

        private Knob(AbstractSelectionList<?> parentList) {
            super(0, 0, 6, 12, (Component)Component.empty());
            this.parentList = parentList;
            this.smoothedHeight = this.calculateKnobHeight();
            this.lastFrameMillis = Util.getMillis();
        }

        private int trackLeft() {
            return this.parentList.getRight() - 6 - 4;
        }

        private int trackTop() {
            return this.parentList.getY();
        }

        private int trackBottom() {
            return this.parentList.getBottom();
        }

        private int trackHeight() {
            return Math.max(1, this.trackBottom() - this.trackTop());
        }

        private double maxScrollAmount() {
            return Math.max(1.0, (double)this.parentList.getMaxScroll());
        }

        private int calculateKnobHeight() {
            int visible = this.trackHeight();
            int height = visible * visible / (int)this.maxScrollAmount();
            return Mth.clamp((int)height, (int)12, (int)(visible - 8));
        }

        private static boolean isPrimaryMouseDown() {
            long window = Minecraft.getInstance().getWindow().getWindow();
            return GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
        }

        public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.dragging && !Knob.isPrimaryMouseDown()) {
                this.dragging = false;
            }
            if (this.parentList.getMaxScroll() <= 0) {
                return;
            }
            double desiredHeight = this.calculateKnobHeight();
            if (((Boolean)ModConfiguration.ANIMATIONS_ENABLED.get()).booleanValue()) {
                long nowMillis = Util.getMillis();
                double deltaSec = Math.min(0.25, (double)(nowMillis - this.lastFrameMillis) / 1000.0);
                this.lastFrameMillis = nowMillis;
                double alpha = 1.0 - Math.exp(-deltaSec / 0.15);
                this.smoothedHeight += (desiredHeight - this.smoothedHeight) * alpha;
                if (Math.abs(this.smoothedHeight - desiredHeight) < 0.05) {
                    this.smoothedHeight = desiredHeight;
                }
            } else {
                this.smoothedHeight = desiredHeight;
                this.lastFrameMillis = Util.getMillis();
            }
            this.setWidth(6);
            this.setHeight((int)Math.round(this.smoothedHeight));
            guiGraphics.fill(this.trackLeft(), this.trackTop(), this.trackLeft() + 6, this.trackBottom(), -16777216);
            if (this.dragging) {
                this.moveTo((double)mouseY - this.dragOffsetPx - (double)this.trackTop());
            }
            int availableSpace = this.trackHeight() - this.getHeight();
            int newX = this.trackLeft();
            int newY = this.trackTop() + (int)(this.parentList.getScrollAmount() * (double)availableSpace / this.maxScrollAmount());
            this.setX(newX);
            this.setY(newY);
            int bodyColor = this.isMouseOver(mouseX, mouseY) || this.dragging ? -5921371 : -8355712;
            int l = this.getX();
            int r = l + 6;
            int t = this.getY();
            int b = t + this.getHeight();
            guiGraphics.fill(l, t, r, t + 1, -4144960);
            guiGraphics.fill(l, t, l + 1, b, -4144960);
            guiGraphics.fill(r - 1, t, r, b, -12566464);
            guiGraphics.fill(l, b - 1, r, b, -12566464);
            guiGraphics.fill(l + 1, t + 1, r - 1, b - 1, bodyColor);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.trackLeft() || mouseX >= (double)(this.trackLeft() + 6) || mouseY < (double)this.trackTop() || mouseY >= (double)this.trackBottom()) {
                return false;
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                this.dragOffsetPx = mouseY - (double)this.getY();
                this.dragging = true;
            } else {
                this.jumpTo(mouseY);
                this.dragging = true;
                this.dragOffsetPx = Math.min(Math.max(0.0, mouseY - (double)this.getY()), (double)this.getHeight());
            }
            return true;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
            if (!this.dragging || button != 0) {
                return false;
            }
            this.moveTo(mouseY - this.dragOffsetPx - (double)this.trackTop());
            return true;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            if (button == 0 && this.dragging) {
                this.dragging = false;
                return true;
            }
            return false;
        }

        private void moveTo(double newTopPx) {
            int availableSpace = this.trackHeight() - (int)Math.round(this.smoothedHeight);
            if (availableSpace <= 0) {
                this.parentList.setScrollAmount(0.0);
                return;
            }
            newTopPx = Mth.clamp((double)newTopPx, (double)0.0, (double)availableSpace);
            this.parentList.setScrollAmount(newTopPx / (double)availableSpace * (double)this.parentList.getMaxScroll());
        }

        private void jumpTo(double mouseY) {
            this.moveTo(mouseY - (double)this.trackTop() - this.smoothedHeight / 2.0);
        }

        protected void updateWidgetNarration(@NotNull NarrationElementOutput narration) {
        }
    }
}

