/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.creative;

import com.eruannie_9.booklinggear.creative.FrameDataHandler;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public abstract class AnimatedCreativeModeTab
extends CreativeModeTab {
    private final Supplier<ItemStack[]> frameSupplier;
    private final FrameDataHandler frameDataHandler;
    private final String modId;
    private final long frameInterval;
    private final boolean useRandomFrame;
    private final RandomSource randomGenerator = RandomSource.m_216327_();
    private long lastFrameCount = -1L;
    private ItemStack cachedIcon = ItemStack.f_41583_;
    private int previousFrameIndex = -1;

    protected AnimatedCreativeModeTab(String modId, Supplier<ItemStack[]> frameSupplier, long frameInterval, FrameDataHandler frameDataHandler, boolean useRandomFrame) {
        super("animatedTab");
        this.modId = modId;
        this.frameSupplier = frameSupplier;
        this.frameInterval = frameInterval;
        this.frameDataHandler = frameDataHandler;
        this.useRandomFrame = useRandomFrame;
    }

    protected AnimatedCreativeModeTab(String modId, Supplier<ItemStack[]> frameSupplier, long frameInterval, boolean useRandomFrame) {
        this(modId, frameSupplier, frameInterval, null, useRandomFrame);
    }

    @NotNull
    public Component m_40786_() {
        return Component.m_237115_((String)(this.modId + ".itemGroup.animatedTab"));
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public ItemStack m_40787_() {
        long currentTime = System.currentTimeMillis();
        long currentFrameCount = currentTime / this.frameInterval;
        if (currentFrameCount != this.lastFrameCount) {
            this.updateCachedIcon(currentFrameCount);
        }
        return this.cachedIcon;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateCachedIcon(long frameCount) {
        int frameIndex;
        this.lastFrameCount = frameCount;
        this.randomGenerator.m_188584_(frameCount);
        ItemStack[] frames = this.frameSupplier.get();
        if (frames.length == 0) {
            this.cachedIcon = ItemStack.f_41583_;
            return;
        }
        this.previousFrameIndex = frameIndex = this.selectFrameIndex(frames.length);
        ItemStack selectedFrame = frames[frameIndex].m_41777_();
        if (this.frameDataHandler != null) {
            this.frameDataHandler.handle(selectedFrame, frameCount);
        }
        this.cachedIcon = selectedFrame;
    }

    private int selectFrameIndex(int frameCount) {
        if (this.useRandomFrame) {
            int randomIndex = this.randomGenerator.m_188503_(frameCount);
            if (frameCount > 1 && randomIndex == this.previousFrameIndex) {
                return (randomIndex + 1) % frameCount;
            }
            return randomIndex;
        }
        return (this.previousFrameIndex + 1) % frameCount;
    }

    @NotNull
    public ItemStack m_6976_() {
        ItemStack[] frames = this.frameSupplier.get();
        return frames.length > 0 ? frames[0].m_41777_() : ItemStack.f_41583_;
    }
}

