/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.visibility.options;

import com.eruannie_9.booklinggear.screen.config.visibility.VisibilityRule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public final class FunctionalVisibilityRule
implements VisibilityRule {
    private final BooleanSupplier condition;
    private final Set<String> visiblePaths;
    private final Set<String> affectedFolders = new HashSet<String>();

    public FunctionalVisibilityRule(BooleanSupplier condition, Collection<String> visiblePaths) {
        this.condition = condition;
        this.visiblePaths = Set.copyOf(visiblePaths);
        if (visiblePaths.isEmpty()) {
            return;
        }
        for (String p : visiblePaths) {
            this.affectedFolders.add(FunctionalVisibilityRule.firstSegment(p));
        }
    }

    private static String firstSegment(String path) {
        int idx = path.indexOf(46);
        return idx < 0 ? path : path.substring(0, idx);
    }

    @Override
    @Nullable
    public Boolean isVisible(String fullPath, Map<String, Object> currentValues) {
        boolean manageThisEntry;
        if (!this.affectedFolders.isEmpty() && !this.affectedFolders.contains(FunctionalVisibilityRule.firstSegment(fullPath))) {
            return null;
        }
        boolean manageAllInFolder = this.visiblePaths.isEmpty();
        boolean bl = manageThisEntry = manageAllInFolder || this.visiblePaths.contains(fullPath);
        if (!manageThisEntry) {
            return null;
        }
        return this.condition.getAsBoolean();
    }
}

