/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.warning;

import com.eruannie_9.booklinggear.util.title.AnimatedScreenTitle;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class WarningScreen
extends Screen {
    private static final int BUTTON_HEIGHT = 20;
    private final Runnable onConfirm;
    private final Runnable onCancel;
    private final List<Component> warnings = new ArrayList<Component>();
    private final List<List<FormattedCharSequence>> pages = new ArrayList<List<FormattedCharSequence>>();
    private int currentPage;
    private Button btnPrev;
    private Button btnNext;
    private Button btnSave;
    private Button btnCancel;
    private int titleY;
    private int textStartY;
    private int buttonsY;
    private AnimatedScreenTitle glintTitle;

    public WarningScreen(List<Component> messages, Runnable onConfirm, Runnable onCancel) {
        super((Component)Component.m_237113_((String)"Warning"));
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        this.warnings.addAll(new LinkedHashSet<Component>(messages));
    }

    protected void m_7856_() {
        super.m_7856_();
        int wrapWidth = (int)((float)this.f_96543_ * 0.8f);
        for (Component c : this.warnings) {
            this.pages.add(this.f_96547_.m_92923_((FormattedText)c, wrapWidth));
        }
        this.btnPrev = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)"<"), b -> this.changePage(-1));
        this.btnNext = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)">"), b -> this.changePage(1));
        this.btnSave = new Button(0, 0, 80, 20, (Component)Component.m_237113_((String)"Save"), b -> this.onConfirm.run());
        this.btnCancel = new Button(0, 0, 80, 20, (Component)Component.m_237113_((String)"Cancel"), b -> this.onCancel.run());
        this.m_142416_((GuiEventListener)this.btnPrev);
        this.m_142416_((GuiEventListener)this.btnNext);
        this.m_142416_((GuiEventListener)this.btnSave);
        this.m_142416_((GuiEventListener)this.btnCancel);
        if (this.glintTitle == null) {
            this.glintTitle = new AnimatedScreenTitle(this.f_96539_.getString());
        }
        this.recalcLayout();
    }

    private void changePage(int delta) {
        int next = this.currentPage + delta;
        if (next >= 0 && next < this.warnings.size()) {
            this.currentPage = next;
            this.recalcLayout();
        }
    }

    private void recalcLayout() {
        int n;
        Objects.requireNonNull(this.f_96547_);
        int titleHeight = 9;
        int gapAfterTitle = 10;
        int gapBeforeBtns = 20;
        if (this.pages.isEmpty()) {
            n = 0;
        } else {
            int n2 = this.pages.get(this.currentPage).size();
            Objects.requireNonNull(this.f_96547_);
            n = n2 * 9;
        }
        int textHeight = n;
        int totalHeight = titleHeight + gapAfterTitle + textHeight + gapBeforeBtns + 20;
        this.titleY = Math.max(10, (this.f_96544_ - totalHeight) / 2);
        this.textStartY = this.titleY + titleHeight + gapAfterTitle;
        this.buttonsY = this.textStartY + textHeight + gapBeforeBtns;
        this.positionButtons();
    }

    private void positionButtons() {
        boolean multi;
        int arrowW = 20;
        int gap = 10;
        int saveW = 80;
        int cancelW = 80;
        this.btnPrev.f_93624_ = multi = this.warnings.size() > 1;
        this.btnNext.f_93624_ = multi;
        this.btnPrev.f_93623_ = this.currentPage > 0;
        this.btnNext.f_93623_ = this.currentPage < this.warnings.size() - 1;
        int totalW = (multi ? 30 : 0) + 80 + 10 + 80 + (multi ? 30 : 0);
        int startX = (this.f_96543_ - totalW) / 2;
        if (multi) {
            this.btnPrev.f_93620_ = startX;
            this.btnPrev.f_93621_ = this.buttonsY;
            startX += 30;
        }
        this.btnSave.f_93620_ = startX;
        this.btnSave.f_93621_ = this.buttonsY;
        this.btnCancel.f_93620_ = startX += 90;
        this.btnCancel.f_93621_ = this.buttonsY;
        if (multi) {
            this.btnNext.f_93620_ = startX += 90;
            this.btnNext.f_93621_ = this.buttonsY;
        }
    }

    public void m_6305_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_96626_(0);
        this.glintTitle.render(poseStack, this.f_96547_, this.f_96543_);
        if (!this.pages.isEmpty()) {
            int y = this.textStartY;
            for (FormattedCharSequence line : this.pages.get(this.currentPage)) {
                int lineW = this.f_96547_.m_92724_(line);
                this.f_96547_.m_92877_(poseStack, line, (float)(this.f_96543_ - lineW) / 2.0f, (float)y, 0xFFFFFF);
                Objects.requireNonNull(this.f_96547_);
                y += 9;
            }
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }
}

