/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.config.warning.options;

import com.eruannie_9.booklinggear.screen.config.warning.JsonWarningList;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractWarningOption<T> {
    private final String id;
    private final ForgeConfigSpec.ConfigValue<T> value;
    private final Component message;

    protected AbstractWarningOption(ForgeConfigSpec.ConfigValue<T> value, Component message) {
        this(AbstractWarningOption.generateId(value, message), value, message);
    }

    protected AbstractWarningOption(String id, ForgeConfigSpec.ConfigValue<T> value, Component message) {
        this.id = id;
        this.value = value;
        this.message = message;
    }

    public String id() {
        return this.id;
    }

    public ForgeConfigSpec.ConfigValue<T> configValue() {
        return this.value;
    }

    public Component warningMessage() {
        return this.message;
    }

    public boolean isSeen() {
        return JsonWarningList.isSeen(this.id);
    }

    public void markSeen() {
        JsonWarningList.markSeen(this.id);
    }

    public abstract boolean shouldConfirm(Object var1);

    private static String generateId(ForgeConfigSpec.ConfigValue<?> v, Component msg) {
        String base = String.join((CharSequence)".", v.getPath()) + "|" + msg.getString();
        return UUID.nameUUIDFromBytes(base.getBytes(StandardCharsets.UTF_8)).toString();
    }
}

