/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.screen.list;

import com.eruannie_9.booklinggear.screen.config.visibility.animation.AnimatedEntry;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public final class EntryList
extends AbstractSelectionList<Entry> {
    private static final int OFFSCREEN = 2000;

    public EntryList(Minecraft minecraft, int width, int height, int top, int bottom, int rowHeight) {
        super(minecraft, width, height, top, bottom, rowHeight);
        this.m_93471_(false);
    }

    public void addEntryInstant(Entry entry) {
        entry.setInstantState(true);
        this.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public void addEntryAnimated(Entry entry) {
        entry.setInstantState(false);
        entry.setTargetVisible(true);
        this.m_7085_((AbstractSelectionList.Entry)entry);
    }

    public void removeEntryAnimated(Entry entry) {
        entry.setTargetVisible(false);
    }

    public void tickAnimations() {
        boolean listChanged = false;
        Iterator iterator = this.m_6702_().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)((Object)iterator.next());
            entry.tickAnimator();
            if (entry.isTargetVisible() || !entry.isGone()) continue;
            iterator.remove();
            listChanged = true;
        }
        if (listChanged) {
            this.m_93410_(this.m_93517_());
        }
    }

    public int m_5759_() {
        return (int)((double)this.f_93388_ * 0.8);
    }

    public int getScrollbarX() {
        return this.f_93388_ - 10;
    }

    protected int m_5756_() {
        return this.f_93388_ + 2000;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        Entry row = (Entry)this.m_93412_(mouseX, mouseY);
        if (row != null && row.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)row);
            this.m_7897_(true);
            return true;
        }
        return false;
    }

    public void m_142291_(@NotNull NarrationElementOutput output) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Entry
    extends AnimatedEntry<Entry> {
        private final EntryList parentList;
        private final EditBox textBox;
        private final Button deleteButton;

        public Entry(EntryList parentList, String value) {
            this.parentList = parentList;
            int rowWidth = parentList.m_5759_();
            int textBoxWidth = rowWidth - 25;
            int textBoxX = (parentList.f_93388_ - rowWidth) / 2;
            this.textBox = new EditBox(Minecraft.m_91087_().f_91062_, textBoxX, 0, textBoxWidth, 20, (Component)Component.m_237119_());
            this.textBox.m_94199_(512);
            this.textBox.m_94144_(value);
            this.deleteButton = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)"x"), b -> parentList.removeEntryAnimated(this));
        }

        public String getValue() {
            return this.textBox.m_94155_().trim();
        }

        public void setValue(String value) {
            this.textBox.m_94144_(value);
        }

        public EditBox getTextBox() {
            return this.textBox;
        }

        public void m_6311_(@NotNull PoseStack poseStack, int index, int yPos, int xPos, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int slideOffset = this.isTargetVisible() ? this.slideX(rowWidth) : -Mth.m_14167_((float)((1.0f - this.easedProgress()) * (float)this.parentList.f_93388_));
            int adjustedY = this.easedY(yPos);
            this.textBox.f_93620_ = xPos + slideOffset;
            this.textBox.f_93621_ = adjustedY;
            this.textBox.m_93674_(rowWidth - 25);
            this.deleteButton.f_93620_ = this.textBox.f_93620_ + this.textBox.m_5711_() + 5;
            this.deleteButton.f_93621_ = adjustedY;
            this.textBox.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.deleteButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean used = false;
            if (this.textBox.m_5953_(mouseX, mouseY)) {
                used = this.textBox.m_6375_(mouseX, mouseY, button);
                this.parentList.m_7522_((GuiEventListener)this);
                this.parentList.m_7897_(true);
                this.parentList.m_6702_().forEach(e -> e.textBox.m_94178_(false));
                this.textBox.m_94178_(true);
                Objects.requireNonNull(Minecraft.m_91087_().f_91080_).m_7522_((GuiEventListener)this.textBox);
            } else {
                this.textBox.m_94178_(false);
            }
            if (this.deleteButton.m_5953_(mouseX, mouseY)) {
                used |= this.deleteButton.m_6375_(mouseX, mouseY, button);
            }
            return used;
        }

        public boolean m_5534_(char character, int modifiers) {
            return this.textBox.m_93696_() && this.textBox.m_5534_(character, modifiers);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            return this.textBox.m_93696_() && this.textBox.m_7933_(keyCode, scanCode, modifiers);
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237119_();
        }
    }
}

