/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TabWidget
extends Button {
    private static final Map<String, Float> SCALE_CACHE = new HashMap<String, Float>();
    public static final SoundPlayStrategy ONLY_IF_NOT_SELECTED = tab -> !tab.isSelected();
    private static final int TAB_TEXTURE_WIDTH = 69;
    private static final int TAB_TEXTURE_HEIGHT = 22;
    private final Screen parentScreen;
    private final Supplier<Boolean> selectedSupplier;
    private final Supplier<ItemStack> iconSupplier;
    private final Supplier<ResourceLocation> pictureSupplier;
    private final ResourceLocation texture;
    private final boolean animation;
    private final float animationSpeed;
    private final float baseScale;
    private final float hoverScale;
    private float currentScale;
    private final boolean usePicture;
    private final String tabId;
    private final boolean showTooltip;
    @Nullable
    private final SoundEvent clickSound;
    @Nullable
    private final SoundPlayStrategy soundPlayStrategy;

    public static void clearScaleCache() {
        SCALE_CACHE.clear();
    }

    public TabWidget(Screen parentScreen, int x, int y, int width, int height, Component title, @NotNull Supplier<Boolean> selectedSupplier, @NotNull Button.OnPress onPress, @NotNull Supplier<ItemStack> iconSupplier, @NotNull Supplier<ResourceLocation> pictureSupplier, float baseScale, float hoverScale, float animationSpeed, boolean animation, @NotNull ResourceLocation tabTexture, @Nullable SoundEvent clickSound, boolean showTooltip, @Nullable SoundPlayStrategy soundPlayStrategy) {
        super(x, y, width, height, title, onPress);
        this.parentScreen = parentScreen;
        this.showTooltip = showTooltip;
        this.selectedSupplier = selectedSupplier;
        this.iconSupplier = iconSupplier;
        this.pictureSupplier = pictureSupplier;
        this.baseScale = baseScale;
        this.hoverScale = hoverScale;
        this.animationSpeed = animationSpeed;
        this.animation = animation;
        this.texture = tabTexture;
        this.clickSound = clickSound;
        this.soundPlayStrategy = soundPlayStrategy;
        this.tabId = title.getString();
        this.usePicture = this.pictureSupplier.get() != null;
        boolean initialSelected = this.selectedSupplier.get();
        this.currentScale = SCALE_CACHE.computeIfAbsent(this.tabId, key -> Float.valueOf(initialSelected ? hoverScale : baseScale)).floatValue();
    }

    public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
        boolean selected = this.isSelected();
        int stateIndex = selected ? 1 : (this.m_198029_() ? 2 : 0);
        int u = stateIndex * 23;
        boolean v = false;
        TabWidget.m_93133_((PoseStack)poseStack, (int)this.f_93620_, (int)this.f_93621_, (float)u, (float)((float)v), (int)this.f_93618_, (int)this.f_93619_, (int)69, (int)22);
        float targetScale = !selected && !this.m_198029_() ? this.baseScale : this.hoverScale;
        this.currentScale = this.animation ? Mth.m_14179_((float)this.animationSpeed, (float)this.currentScale, (float)targetScale) : targetScale;
        SCALE_CACHE.put(this.tabId, Float.valueOf(this.currentScale));
        int centerX = this.f_93620_ + 11;
        int centerY = this.f_93621_ + 11;
        if (this.usePicture) {
            ResourceLocation currentPic = this.pictureSupplier.get();
            if (currentPic != null) {
                this.renderPicture(poseStack, currentPic, centerX, centerY, this.currentScale);
            }
        } else {
            ItemStack currentIcon = this.iconSupplier.get();
            if (!currentIcon.m_41619_()) {
                this.renderItem(currentIcon, centerX, centerY, this.currentScale, 12.0f);
            }
        }
        if (this.showTooltip && this.m_198029_() && this.parentScreen != null) {
            this.parentScreen.m_96602_(poseStack, this.m_6035_(), mouseX, mouseY);
        }
    }

    public void m_7435_(@NotNull SoundManager soundManager) {
        if (this.soundPlayStrategy != null) {
            if (this.soundPlayStrategy.shouldPlaySound(this)) {
                this.playClickSound(soundManager);
            }
        } else {
            this.playClickSound(soundManager);
        }
    }

    private void playClickSound(@NotNull SoundManager soundManager) {
        if (this.clickSound != null) {
            soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)this.clickSound, (float)1.0f));
        } else {
            super.m_7435_(soundManager);
        }
    }

    public boolean isSelected() {
        return this.selectedSupplier.get();
    }

    private void renderItem(ItemStack stack, int x, int y, float scale, float size) {
        PoseStack mvStack = RenderSystem.m_157191_();
        mvStack.m_85836_();
        mvStack.m_85837_((double)x, (double)y, 100.0);
        mvStack.m_85841_(size * scale, -(size * scale), size * scale);
        RenderSystem.m_157182_();
        PoseStack itemPose = new PoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(stack, null, null, 0);
        if (!model.m_7547_()) {
            Lighting.m_84930_();
        } else {
            Lighting.m_84931_();
        }
        Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemTransforms.TransformType.GUI, false, itemPose, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, model);
        buffer.m_109911_();
        Lighting.m_84931_();
        mvStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private void renderPicture(PoseStack poseStack, ResourceLocation pic, int x, int y, float scale) {
        int imgW = 17;
        int imgH = 16;
        poseStack.m_85836_();
        poseStack.m_85837_((double)x - (double)((float)imgW * scale) / 2.0, (double)y - (double)((float)imgH * scale) / 2.0, 100.0);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)pic);
        TabWidget.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)imgW, (int)imgH, (int)imgW, (int)imgH);
        poseStack.m_85849_();
    }

    public static List<TabWidget> createTabsFromItemData(Screen parentScreen, int bgLeft, int bgTop, int bgWidth, List<TabItemData> dataList, ResourceLocation tabTexture, boolean animation, boolean showTooltip, Function<TabItemData, SoundPlayStrategy> soundStrategyMapper) {
        ArrayList<TabWidget> widgets = new ArrayList<TabWidget>();
        int startY = bgTop + 5;
        int xPos = bgLeft + bgWidth;
        for (int i = 0; i < dataList.size(); ++i) {
            TabItemData d = dataList.get(i);
            int yPos = startY + i * 24;
            SoundPlayStrategy strategy = soundStrategyMapper.apply(d);
            TabWidget widget = new Builder(parentScreen, xPos, yPos, 23, 22, (Component)Component.m_237113_((String)d.label()), d.onPress(), d.selected()).iconSupplier(d.icon()).baseScale(d.baseScale()).hoverScale(d.hoverScale()).animationSpeed(d.animationSpeed()).animation(animation).tabTexture(tabTexture).clickSound(d.clickSound()).showTooltip(showTooltip).soundPlayStrategy(strategy).build();
            widgets.add(widget);
        }
        return widgets;
    }

    public static List<TabWidget> createTabsFromPictureData(Screen parentScreen, int bgLeft, int bgTop, int bgWidth, List<TabPictureData> dataList, ResourceLocation tabTexture, boolean animation, boolean showTooltip, Function<TabPictureData, SoundPlayStrategy> soundStrategyMapper) {
        ArrayList<TabWidget> widgets = new ArrayList<TabWidget>();
        int startY = bgTop + 5;
        int xPos = bgLeft + bgWidth;
        for (int i = 0; i < dataList.size(); ++i) {
            TabPictureData d = dataList.get(i);
            int yPos = startY + i * 24;
            SoundPlayStrategy strategy = soundStrategyMapper.apply(d);
            TabWidget widget = new Builder(parentScreen, xPos, yPos, 23, 22, (Component)Component.m_237113_((String)d.label()), d.onPress(), d.selected()).pictureSupplier(d.picture()).baseScale(d.baseScale()).hoverScale(d.hoverScale()).animationSpeed(d.animationSpeed()).animation(animation).tabTexture(tabTexture).clickSound(d.clickSound()).showTooltip(showTooltip).soundPlayStrategy(strategy).build();
            widgets.add(widget);
        }
        return widgets;
    }

    @FunctionalInterface
    public static interface SoundPlayStrategy {
        public boolean shouldPlaySound(TabWidget var1);
    }

    public record TabItemData(String label, Supplier<Boolean> selected, Button.OnPress onPress, Supplier<ItemStack> icon, float baseScale, float hoverScale, float animationSpeed, @Nullable SoundEvent clickSound) {
    }

    public static class Builder {
        private final Screen parentScreen;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Component title;
        private final Button.OnPress onPress;
        private final Supplier<Boolean> selectedSupplier;
        private Supplier<ItemStack> iconSupplier = () -> ItemStack.f_41583_;
        private Supplier<ResourceLocation> pictureSupplier = () -> null;
        private float baseScale = 1.0f;
        private float hoverScale = 1.25f;
        private float animationSpeed = 0.1f;
        private boolean animation = true;
        private ResourceLocation tabTexture = new ResourceLocation("minecraft", "textures/gui/widgets.png");
        private boolean showTooltip = true;
        private SoundEvent clickSound = null;
        private SoundPlayStrategy soundPlayStrategy = null;

        public Builder(Screen parentScreen, int x, int y, int width, int height, Component title, Button.OnPress onPress, Supplier<Boolean> selectedSupplier) {
            this.parentScreen = parentScreen;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.title = title;
            this.onPress = onPress;
            this.selectedSupplier = selectedSupplier;
        }

        public Builder iconSupplier(Supplier<ItemStack> iconSupplier) {
            this.iconSupplier = iconSupplier;
            return this;
        }

        public Builder pictureSupplier(Supplier<ResourceLocation> pictureSupplier) {
            this.pictureSupplier = pictureSupplier;
            return this;
        }

        public Builder baseScale(float baseScale) {
            this.baseScale = baseScale;
            return this;
        }

        public Builder hoverScale(float hoverScale) {
            this.hoverScale = hoverScale;
            return this;
        }

        public Builder animationSpeed(float animationSpeed) {
            this.animationSpeed = animationSpeed;
            return this;
        }

        public Builder animation(boolean animation) {
            this.animation = animation;
            return this;
        }

        public Builder tabTexture(ResourceLocation texture) {
            this.tabTexture = texture;
            return this;
        }

        public Builder showTooltip(boolean showTooltip) {
            this.showTooltip = showTooltip;
            return this;
        }

        public Builder clickSound(SoundEvent clickSound) {
            this.clickSound = clickSound;
            return this;
        }

        public Builder soundPlayStrategy(SoundPlayStrategy strategy) {
            this.soundPlayStrategy = strategy;
            return this;
        }

        public TabWidget build() {
            return new TabWidget(this.parentScreen, this.x, this.y, this.width, this.height, this.title, this.selectedSupplier, this.onPress, this.iconSupplier, this.pictureSupplier, this.baseScale, this.hoverScale, this.animationSpeed, this.animation, this.tabTexture, this.clickSound, this.showTooltip, this.soundPlayStrategy);
        }
    }

    public record TabPictureData(String label, Supplier<Boolean> selected, Button.OnPress onPress, Supplier<ResourceLocation> picture, float baseScale, float hoverScale, float animationSpeed, @Nullable SoundEvent clickSound) {
    }
}

