/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util.scroll;

import com.eruannie_9.booklinggear.ModConfiguration;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public final class ScrollSlider {
    private static final int BAR_WIDTH = 6;
    private static final int MIN_KNOB_HEIGHT = 12;
    private static final int RIGHT_PADDING = 4;
    private static final int TRACK_COLOR = -16777216;
    private static final int BODY_COLOR = -8355712;
    private static final int HIGHLIGHT_COLOR = -4144960;
    private static final int SHADOW_COLOR = -12566464;
    private static final int BODY_HOVER_COLOR = -5921371;
    private final Knob sliderKnob;

    private ScrollSlider(AbstractSelectionList<?> targetList) {
        this.sliderKnob = new Knob(targetList);
    }

    public static ScrollSlider attach(AbstractSelectionList<?> targetList) {
        return new ScrollSlider(targetList);
    }

    public Knob widget() {
        return this.sliderKnob;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Knob
    extends AbstractWidget {
        private static final double SMOOTHING_TAU_SEC = 0.15;
        private final AbstractSelectionList<?> parentList;
        private boolean dragging;
        private double dragOffsetPx;
        private double smoothedHeight;
        private long lastFrameMillis;

        private Knob(AbstractSelectionList<?> parentList) {
            super(0, 0, 6, 12, (Component)Component.m_237119_());
            this.parentList = parentList;
            this.smoothedHeight = this.calculateKnobHeight();
            this.lastFrameMillis = Util.m_137550_();
        }

        private int trackLeft() {
            return this.parentList.getRight() - 6 - 4;
        }

        private int trackTop() {
            return this.parentList.getTop();
        }

        private int trackBottom() {
            return this.parentList.getBottom();
        }

        private int trackHeight() {
            return Math.max(1, this.trackBottom() - this.trackTop());
        }

        private double maxScrollAmount() {
            return Math.max(1.0, (double)this.parentList.m_93518_());
        }

        private int calculateKnobHeight() {
            int visible = this.trackHeight();
            int height = visible * visible / (int)this.maxScrollAmount();
            return Mth.m_14045_((int)height, (int)12, (int)(visible - 8));
        }

        private static boolean isPrimaryMouseDown() {
            long window = Minecraft.m_91087_().m_91268_().m_85439_();
            return GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
        }

        public void m_6303_(@NotNull PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.dragging && !Knob.isPrimaryMouseDown()) {
                this.dragging = false;
            }
            if (this.parentList.m_93518_() <= 0) {
                return;
            }
            double desiredHeight = this.calculateKnobHeight();
            if (((Boolean)ModConfiguration.ANIMATIONS_ENABLED.get()).booleanValue()) {
                long nowMillis = Util.m_137550_();
                double deltaSec = Math.min(0.25, (double)(nowMillis - this.lastFrameMillis) / 1000.0);
                this.lastFrameMillis = nowMillis;
                double alpha = 1.0 - Math.exp(-deltaSec / 0.15);
                this.smoothedHeight += (desiredHeight - this.smoothedHeight) * alpha;
                if (Math.abs(this.smoothedHeight - desiredHeight) < 0.05) {
                    this.smoothedHeight = desiredHeight;
                }
            } else {
                this.smoothedHeight = desiredHeight;
                this.lastFrameMillis = Util.m_137550_();
            }
            this.f_93619_ = (int)Math.round(this.smoothedHeight);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)this.trackLeft(), (int)this.trackTop(), (int)(this.trackLeft() + 6), (int)this.trackBottom(), (int)-16777216);
            int availableSpace = this.trackHeight() - this.f_93619_;
            this.f_93620_ = this.trackLeft();
            this.f_93621_ = this.trackTop() + (int)(this.parentList.m_93517_() * (double)availableSpace / this.maxScrollAmount());
            int bodyColor = this.m_5953_(mouseX, mouseY) || this.dragging ? -5921371 : -8355712;
            int l = this.f_93620_;
            int r = l + 6;
            int t = this.f_93621_;
            int b = t + this.f_93619_;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)l, (int)t, (int)(l + 1), (int)b, (int)-4144960);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)l, (int)t, (int)r, (int)(t + 1), (int)-4144960);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(r - 1), (int)t, (int)r, (int)b, (int)-12566464);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)l, (int)(b - 1), (int)r, (int)b, (int)-12566464);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(l + 1), (int)(t + 1), (int)(r - 1), (int)(b - 1), (int)bodyColor);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.trackLeft() || mouseX >= (double)(this.trackLeft() + 6) || mouseY < (double)this.trackTop() || mouseY >= (double)this.trackBottom()) {
                return false;
            }
            if (this.m_5953_(mouseX, mouseY)) {
                this.dragOffsetPx = mouseY - (double)this.f_93621_;
                this.dragging = true;
            } else {
                this.jumpTo(mouseY);
                this.dragging = true;
                this.dragOffsetPx = this.smoothedHeight / 2.0;
            }
            return true;
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
            if (!this.dragging || button != 0) {
                return false;
            }
            this.moveTo(mouseY - this.dragOffsetPx - (double)this.trackTop());
            return true;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (button == 0 && this.dragging) {
                this.dragging = false;
                return true;
            }
            return false;
        }

        private void moveTo(double newTopPx) {
            int availableSpace = this.trackHeight() - (int)Math.round(this.smoothedHeight);
            if (availableSpace <= 0) {
                this.parentList.m_93410_(0.0);
                return;
            }
            newTopPx = Mth.m_14008_((double)newTopPx, (double)0.0, (double)availableSpace);
            this.parentList.m_93410_(newTopPx / (double)availableSpace * (double)this.parentList.m_93518_());
        }

        private void jumpTo(double mouseY) {
            this.moveTo(mouseY - (double)this.trackTop() - this.smoothedHeight / 2.0);
        }

        public void m_142291_(@NotNull NarrationElementOutput narration) {
        }
    }
}

