/*
 * Decompiled with CFR 0.152.
 */
package com.eruannie_9.booklinggear.util.title;

import com.eruannie_9.booklinggear.util.screen.TextUtil;
import com.eruannie_9.booklinggear.util.title.GlintTitleRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class AnimatedScreenTitle {
    private static final int DEFAULT_Y = 15;
    private static final long GLOBAL_START_EPOCH = Util.m_137550_();
    private final String titleText;
    private final long startEpochMs;
    private final int yPos;
    private IntSupplier rightEdgeSupplier = () -> Integer.MAX_VALUE;

    public AnimatedScreenTitle(String titleText) {
        this(titleText, 15);
    }

    public AnimatedScreenTitle(String titleText, int yPos) {
        this.titleText = titleText;
        this.yPos = yPos;
        this.startEpochMs = GLOBAL_START_EPOCH;
    }

    public void avoidRightEdge(IntSupplier rightEdgeSupplier) {
        this.rightEdgeSupplier = rightEdgeSupplier;
    }

    public void render(PoseStack poseStack, Font font, int screenWidth) {
        int centerX = screenWidth / 2;
        int rightBoundary = Math.min(this.rightEdgeSupplier.getAsInt() - 5, screenWidth - 10);
        int allowableHalfWidth = 2 * Math.max(0, rightBoundary - centerX);
        int maximumTextWidth = Math.min(screenWidth - 20, allowableHalfWidth);
        String displayText = TextUtil.abbreviate(font, this.titleText, maximumTextWidth);
        GlintTitleRenderer.render(poseStack, font, displayText, screenWidth, this.yPos, this.startEpochMs);
    }
}

