/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.config.rendering;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import lombok.Generated;
import net.lopymine.mtd.utils.CodecUtils;

public class HandRenderingConfig {
    public static final Codec<HandRenderingConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("scale", 1.0, Codec.DOUBLE, HandRenderingConfig::getScale), CodecUtils.option("offsetX", 0.0, Codec.DOUBLE, HandRenderingConfig::getOffsetX), CodecUtils.option("offsetY", 0.0, Codec.DOUBLE, HandRenderingConfig::getOffsetY), CodecUtils.option("offsetZ", 0.0, Codec.DOUBLE, HandRenderingConfig::getOffsetZ), CodecUtils.option("rotationX", 0.0, Codec.DOUBLE, HandRenderingConfig::getRotationX), CodecUtils.option("rotationY", 0.0, Codec.DOUBLE, HandRenderingConfig::getRotationY), CodecUtils.option("rotationZ", 0.0, Codec.DOUBLE, HandRenderingConfig::getRotationZ)).apply((Applicative)instance, HandRenderingConfig::new));
    private double scale;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private double rotationX;
    private double rotationY;
    private double rotationZ;

    public HandRenderingConfig(double scale, double offsetX, double offsetY, double offsetZ, double rotationX, double rotationY, double rotationZ) {
        this.scale = scale;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
    }

    public static Supplier<HandRenderingConfig> getNewInstance() {
        return () -> CodecUtils.parseNewInstanceHacky(CODEC);
    }

    public void copy(HandRenderingConfig anotherHandConfig) {
        this.scale = anotherHandConfig.getScale();
        this.offsetX = anotherHandConfig.getOffsetX();
        this.offsetY = anotherHandConfig.getOffsetY();
        this.offsetZ = anotherHandConfig.getOffsetZ();
        this.rotationX = anotherHandConfig.getRotationX();
        this.rotationY = anotherHandConfig.getRotationY();
        this.rotationZ = anotherHandConfig.getRotationZ();
    }

    @Generated
    public double getScale() {
        return this.scale;
    }

    @Generated
    public double getOffsetX() {
        return this.offsetX;
    }

    @Generated
    public double getOffsetY() {
        return this.offsetY;
    }

    @Generated
    public double getOffsetZ() {
        return this.offsetZ;
    }

    @Generated
    public double getRotationX() {
        return this.rotationX;
    }

    @Generated
    public double getRotationY() {
        return this.rotationY;
    }

    @Generated
    public double getRotationZ() {
        return this.rotationZ;
    }

    @Generated
    public void setScale(double scale) {
        this.scale = scale;
    }

    @Generated
    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    @Generated
    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    @Generated
    public void setOffsetZ(double offsetZ) {
        this.offsetZ = offsetZ;
    }

    @Generated
    public void setRotationX(double rotationX) {
        this.rotationX = rotationX;
    }

    @Generated
    public void setRotationY(double rotationY) {
        this.rotationY = rotationY;
    }

    @Generated
    public void setRotationZ(double rotationZ) {
        this.rotationZ = rotationZ;
    }
}

