/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.doll.data;

import lombok.Generated;
import net.lopymine.mtd.doll.data.TotemDollRenderProperties;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.doll.renderer.special.TotemDollGuiElementRenderer;
import net.lopymine.mtd.model.base.MModel;
import net.lopymine.mtd.model.bb.manager.BlockBenchModelManager;
import net.minecraft.class_2960;
import net.minecraft.class_4597;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TotemDollData {
    private boolean shouldRecreateStandardModel;
    @Nullable
    private TotemDollModel standardModel;
    @Nullable
    private TotemDollModel frameModel;
    @NotNull
    private TotemDollRenderProperties renderProperties = new TotemDollRenderProperties();

    public TotemDollData(@Nullable String nickname, @NotNull TotemDollSprites sprites) {
        this.renderProperties.refresh(sprites);
        this.renderProperties.setNickname(nickname);
    }

    public TotemDollData(@NotNull TotemDollRenderProperties properties) {
        this.renderProperties.copyFrom(properties);
    }

    public static TotemDollData create(@Nullable String nickname) {
        return new TotemDollData(nickname, TotemDollSprites.create());
    }

    public TotemDollSprites getStandardSprites() {
        return this.renderProperties.getStandardSprites();
    }

    @Nullable
    public String getNickname() {
        return this.renderProperties.getNickname();
    }

    public void setStandardMModel(@NotNull class_2960 modelId) {
        BlockBenchModelManager.consumeModelById(modelId, this::setStandardMModel);
    }

    public void setStandardMModel(@Nullable MModel model) {
        this.renderProperties.setStandardMModel(model);
        if (model == null) {
            return;
        }
        this.standardModel = this.renderProperties.createStandardModel();
    }

    public void setFrameMModel(@NotNull class_2960 id) {
        this.renderProperties.consumeFrameMModel(id, this::setFrameMModel);
    }

    public void setFrameMModel(@Nullable MModel frameMModel) {
        this.renderProperties.setFrameMModel(frameMModel);
    }

    @Nullable
    private TotemDollModel getFrameModelBasedOnFrameMModel() {
        if (this.renderProperties.getFrameMModel() != null) {
            if (this.frameModel == null || !this.frameModel.getMain().equals((Object)this.renderProperties.getFrameMModel())) {
                this.frameModel = this.renderProperties.createFrameModel();
                return this.frameModel;
            }
            return this.frameModel;
        }
        return null;
    }

    public void clearAllFrameModelsCompletely() {
        this.clearFrameModel();
        this.renderProperties.clearCachedFrameMModels();
    }

    public void clearFrameModel() {
        if (this.frameModel != null) {
            this.frameModel.resetPartsVisibility();
            this.frameModel = null;
        }
    }

    public void clearFrameSprites() {
        this.renderProperties.setFrameSprites(null);
    }

    @NotNull
    public TotemDollModel getModelToRender() {
        TotemDollModel tempModel = this.getFrameModelBasedOnFrameMModel();
        if (tempModel != null) {
            return tempModel;
        }
        if (this.standardModel != null && !this.shouldRecreateStandardModel) {
            return this.standardModel;
        }
        this.setStandardMModel(TotemDollModel.createDollModel());
        if (this.shouldRecreateStandardModel) {
            this.shouldRecreateStandardModel = false;
        }
        return this.standardModel;
    }

    @NotNull
    public TotemDollSprites getSpritesToRender() {
        return this.renderProperties.getFrameSprites() == null ? this.renderProperties.getStandardSprites() : this.renderProperties.getFrameSprites();
    }

    public void setSprites(@NotNull TotemDollSprites sprites) {
        this.renderProperties.setStandardSprites(sprites);
    }

    public void setFrameSprites(@Nullable TotemDollSprites frameSprites) {
        this.renderProperties.setFrameSprites(frameSprites);
    }

    public void setFrameSprites(@Nullable class_742 playerEntity) {
        if (playerEntity == null) {
            return;
        }
        class_8685 skinTextures = playerEntity.method_52814();
        class_2960 skinTexture = skinTextures.comp_1626();
        class_2960 capeTexture = skinTextures.comp_1627();
        class_2960 elytraTexture = skinTextures.comp_1628();
        boolean slim = skinTextures.comp_1629() == class_8685.class_7920.field_41122;
        this.renderProperties.setFrameSprites(skinTexture, capeTexture, elytraTexture, slim, true);
    }

    @NotNull
    public TotemDollData copy() {
        return new TotemDollData(this.renderProperties);
    }

    @NotNull
    public TotemDollData refreshAndApplyRenderProperties() {
        return this.refreshRenderProperties().applyRenderProperties();
    }

    @NotNull
    public TotemDollData refreshRenderProperties() {
        this.clearFrameModel();
        this.clearFrameSprites();
        this.getModelToRender().resetPartsVisibility();
        this.renderProperties.refresh();
        return this;
    }

    @NotNull
    public TotemDollData applyRenderProperties() {
        this.renderProperties.applyToModel(this.getModelToRender());
        return this;
    }

    @NotNull
    public TotemDollGuiElementRenderer getGuiRenderer(class_4597.class_4598 immediate) {
        return TotemDollGuiElementRenderer.getRenderer(this.renderProperties, immediate);
    }

    @Generated
    public boolean isShouldRecreateStandardModel() {
        return this.shouldRecreateStandardModel;
    }

    @Nullable
    @Generated
    public TotemDollModel getStandardModel() {
        return this.standardModel;
    }

    @Nullable
    @Generated
    public TotemDollModel getFrameModel() {
        return this.frameModel;
    }

    @NotNull
    @Generated
    public TotemDollRenderProperties getRenderProperties() {
        return this.renderProperties;
    }

    @Generated
    public void setShouldRecreateStandardModel(boolean shouldRecreateStandardModel) {
        this.shouldRecreateStandardModel = shouldRecreateStandardModel;
    }

    @Generated
    public void setStandardModel(@Nullable TotemDollModel standardModel) {
        this.standardModel = standardModel;
    }

    @Generated
    public void setFrameModel(@Nullable TotemDollModel frameModel) {
        this.frameModel = frameModel;
    }

    @Generated
    public void setRenderProperties(@NotNull TotemDollRenderProperties renderProperties) {
        if (renderProperties == null) {
            throw new NullPointerException("renderProperties is marked non-null but is null");
        }
        this.renderProperties = renderProperties;
    }
}

