/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.lopymine.mtd.MyTotemDoll;
import net.lopymine.mtd.config.MyTotemDollConfig;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.manager.TotemDollManager;
import net.lopymine.mtd.doll.renderer.TotemDollRenderer;
import net.lopymine.mtd.extension.ItemStackExtension;
import net.lopymine.mtd.gui.tooltip.combined.CombinedTooltipData;
import net.lopymine.mtd.gui.tooltip.state.LoadingStateTooltipData;
import net.lopymine.mtd.gui.tooltip.tags.TagsTooltipData;
import net.lopymine.mtd.gui.tooltip.wrapped.WrappedTextTooltipData;
import net.lopymine.mtd.tag.manager.TagsManager;
import net.lopymine.mtd.utils.ScreenUtils;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_471;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Shadow
    public abstract boolean method_31574(class_1792 var1);

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getName"})
    private class_2561 getName(class_2561 original) {
        if (!MyTotemDollConfig.getInstance().isModEnabled() || !this.method_31574(class_1802.field_8288)) {
            return original;
        }
        String string = original.getString();
        if (!string.contains("|")) {
            return original;
        }
        String[] data = TagsManager.getDataFromString(string);
        String name = data[0];
        String tags = data[1];
        if (tags == null || name == null) {
            return original;
        }
        return class_2561.method_43470((String)name).method_10862(original.method_10866());
    }

    @ModifyReturnValue(at={@At(value="RETURN")}, method={"getTooltipData"})
    private Optional<class_5632> getTooltipData(Optional<class_5632> original) {
        class_1799 itemStack = (class_1799)this;
        if (!TotemDollRenderer.canRender(itemStack)) {
            return original;
        }
        class_2561 customName = ItemStackExtension.getRealCustomName(itemStack);
        if (customName == null) {
            return original;
        }
        String[] data = TagsManager.getDataFromString(customName.getString());
        Optional<class_5632> loadingStateTooltipData = this.getLoadingStateTooltipData(data);
        Optional<class_5632> tagsTooltipData = this.getTagsTooltipData(data);
        List<class_5684> list = Stream.of(loadingStateTooltipData, tagsTooltipData).flatMap(Optional::stream).map(class_5684::method_32663).toList();
        return Optional.of(new CombinedTooltipData(list));
    }

    @Unique
    private Optional<class_5632> getLoadingStateTooltipData(String[] data) {
        class_437 currentScreen = class_310.method_1551().field_1755;
        if (!(currentScreen instanceof class_471) && !ScreenUtils.hasShiftDown()) {
            return Optional.empty();
        }
        if (data.length == 0) {
            return Optional.empty();
        }
        String o = data[0];
        TotemDollData totemDollData = TotemDollManager.getDoll(o);
        return Optional.of(new LoadingStateTooltipData(totemDollData.getStandardSprites().getState()));
    }

    @Unique
    private Optional<class_5632> getTagsTooltipData(String[] data) {
        if (data.length < 2) {
            return Optional.empty();
        }
        String tags = data[1];
        if (tags == null || tags.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new CombinedTooltipData(new WrappedTextTooltipData((class_2561)MyTotemDoll.text("tags.title", new Object[0]).method_27692(class_124.field_1080)), new TagsTooltipData(tags)));
    }
}

