/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.utils.texture;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import net.lopymine.mtd.atlas.manager.MyTotemDollAtlasSpriteManager;
import net.lopymine.mtd.client.MyTotemDollClient;
import net.lopymine.mtd.doll.data.TotemDollData;
import net.lopymine.mtd.doll.data.TotemDollSprites;
import net.lopymine.mtd.utils.texture.FailedAction;
import net.lopymine.mtd.utils.texture.SuccessAction;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_8685;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerSkinUtils {
    public static void downloadSkin(@NotNull String textureUrl, @NotNull class_2960 textureId, @Nullable SuccessAction onSuccessRegistration, @Nullable FailedAction onFailedRegistration, boolean skin) {
        block2: {
            try {
                class_1011 nativeImage = PlayerSkinUtils.download(textureUrl);
                class_1011 image = skin ? PlayerSkinUtils.remapSkinTexture(nativeImage) : PlayerSkinUtils.remapTextureToStandardSize(nativeImage, true);
                MyTotemDollAtlasSpriteManager.registerSpecialSkinSprite(textureId, image, true, sprite -> {
                    if (onSuccessRegistration != null) {
                        onSuccessRegistration.onSuccess(sprite);
                    }
                });
            }
            catch (Exception e) {
                MyTotemDollClient.LOGGER.error("Failed to download skin texture with id \"{}\": ", (Object)textureId, (Object)e);
                if (onFailedRegistration == null) break block2;
                onFailedRegistration.onFailed(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static class_1011 download(String uri) throws IOException {
        class_1011 image;
        HttpURLConnection connection = null;
        MyTotemDollClient.LOGGER.debug("Downloading HTTP texture from {}", (Object)uri);
        URI currentUri = URI.create(uri);
        try {
            connection = (HttpURLConnection)currentUri.toURL().openConnection(class_310.method_1551().method_1487());
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            int i = connection.getResponseCode();
            if (i / 100 != 2) {
                String url = String.valueOf(currentUri);
                throw new IOException("Failed to open " + url + ", HTTP error code: " + i);
            }
            image = class_1011.method_49277((byte[])connection.getInputStream().readAllBytes());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return image;
    }

    @NotNull
    public static class_1011 remapTextureToStandardSize(class_1011 image, boolean closeOriginal) {
        if (image.method_4307() == 64 && image.method_4323() == 64) {
            return image;
        }
        class_1011 nativeImage = new class_1011(64, 64, true);
        nativeImage.method_4317(image);
        if (closeOriginal) {
            image.close();
        }
        return nativeImage;
    }

    public static class_1011 remapSkinTexture(class_1011 image) {
        boolean bl;
        int i = image.method_4323();
        boolean bl2 = bl = i == 32;
        if (bl) {
            class_1011 nativeImage = new class_1011(64, 64, true);
            nativeImage.method_4317(image);
            image.close();
            image = nativeImage;
            nativeImage.method_4326(0, 32, 64, 32, 0);
            nativeImage.method_4304(4, 16, 16, 32, 4, 4, true, false);
            nativeImage.method_4304(8, 16, 16, 32, 4, 4, true, false);
            nativeImage.method_4304(0, 20, 24, 32, 4, 12, true, false);
            nativeImage.method_4304(4, 20, 16, 32, 4, 12, true, false);
            nativeImage.method_4304(8, 20, 8, 32, 4, 12, true, false);
            nativeImage.method_4304(12, 20, 16, 32, 4, 12, true, false);
            nativeImage.method_4304(44, 16, -8, 32, 4, 4, true, false);
            nativeImage.method_4304(48, 16, -8, 32, 4, 4, true, false);
            nativeImage.method_4304(40, 20, 0, 32, 4, 12, true, false);
            nativeImage.method_4304(44, 20, -8, 32, 4, 12, true, false);
            nativeImage.method_4304(48, 20, -16, 32, 4, 12, true, false);
            nativeImage.method_4304(52, 20, -8, 32, 4, 12, true, false);
        }
        PlayerSkinUtils.stripAlpha(image, 0, 0, 32, 16);
        if (bl) {
            PlayerSkinUtils.stripColor(image, 32, 0, 64, 32);
        }
        PlayerSkinUtils.stripAlpha(image, 0, 16, 64, 32);
        PlayerSkinUtils.stripAlpha(image, 16, 48, 48, 64);
        return image;
    }

    private static void stripColor(class_1011 image, int x1, int y1, int x2, int y2) {
        int j;
        int i;
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                int k = image.method_61940(i, j);
                if (class_9848.method_61320((int)k) >= 128) continue;
                return;
            }
        }
        for (i = x1; i < x2; ++i) {
            for (j = y1; j < y2; ++j) {
                image.method_61941(i, j, image.method_61940(i, j) & 0xFFFFFF);
            }
        }
    }

    private static void stripAlpha(class_1011 image, int x1, int y1, int x2, int y2) {
        for (int i = x1; i < x2; ++i) {
            for (int j = y1; j < y2; ++j) {
                image.method_61941(i, j, class_9848.method_61334((int)image.method_61940(i, j)));
            }
        }
    }

    public static void setupClientTextures(TotemDollData data) {
        class_310.method_1551().method_1582().method_52863(class_310.method_1551().method_53462()).thenAccept(optional -> {
            if (optional.isEmpty()) {
                return;
            }
            class_8685 skinTextures = (class_8685)optional.get();
            data.setSprites(TotemDollSprites.of(skinTextures));
        });
    }
}

