/*
 * Decompiled with CFR 0.152.
 */
package net.lopymine.mtd.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.fabricmc.loader.api.FabricLoader;
import net.lopymine.mtd.config.other.vector.Vec2i;
import net.lopymine.mtd.config.rendering.RenderingConfig;
import net.lopymine.mtd.config.totem.TotemDollArmsType;
import net.lopymine.mtd.config.totem.TotemDollSkinType;
import net.lopymine.mtd.doll.model.TotemDollModel;
import net.lopymine.mtd.utils.CodecUtils;
import net.lopymine.mtd.utils.ConfigUtils;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyTotemDollConfig {
    public static final Codec<MyTotemDollConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group(CodecUtils.option("mod_enabled", true, Codec.BOOL, MyTotemDollConfig::isModEnabled), CodecUtils.option("debug_log_enabled", false, Codec.BOOL, MyTotemDollConfig::isDebugLogEnabled), CodecUtils.option("rendering_config", RenderingConfig.getNewInstance(), RenderingConfig.CODEC, MyTotemDollConfig::getRenderingConfig), CodecUtils.option("standard_doll_skin_data", "", Codec.STRING, MyTotemDollConfig::getStandardTotemDollSkinValue), CodecUtils.option("standard_doll_skin_type", TotemDollSkinType.STEVE, TotemDollSkinType.CODEC, MyTotemDollConfig::getStandardTotemDollSkinType), CodecUtils.option("standard_doll_model_data", TotemDollModel.TWO_D_MODEL_ID, class_2960.field_25139, MyTotemDollConfig::getStandardTotemDollModelValue), CodecUtils.option("standard_doll_model_arms_type", TotemDollArmsType.WIDE, TotemDollArmsType.CODEC, MyTotemDollConfig::getStandardTotemDollArmsType), CodecUtils.option("tag_button_pos", new Vec2i(155, 48), Vec2i.CODEC, MyTotemDollConfig::getTagButtonPos), CodecUtils.option("use_vanilla_totem_model", false, Codec.BOOL, MyTotemDollConfig::isUseVanillaTotemModel), (App)Codec.INT.optionalFieldOf("better_tag_menu_tooltip_size").xmap(o -> o.orElse(60), Optional::of).forGetter(MyTotemDollConfig::getBetterTagMenuTooltipSize), CodecUtils.option("tag_menu_tooltip_model_scale", Float.valueOf(1.0f), Codec.FLOAT, MyTotemDollConfig::getTagMenuTooltipModelScale), CodecUtils.option("executor_threads_count", 6, Codec.INT, MyTotemDollConfig::getParallelTasksCount), CodecUtils.option("first_run", true, Codec.BOOL, MyTotemDollConfig::isFirstRun), CodecUtils.option("support_other_mods_totems", true, Codec.BOOL, MyTotemDollConfig::isSupportOtherModsTotems)).apply((Applicative)instance, MyTotemDollConfig::new));
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("my-totem-doll.json5").toFile();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"My Totem Doll/Config");
    private static MyTotemDollConfig INSTANCE;
    private boolean modEnabled;
    private boolean debugLogEnabled;
    private RenderingConfig renderingConfig;
    private String standardTotemDollSkinValue;
    private TotemDollSkinType standardTotemDollSkinType;
    private class_2960 standardTotemDollModelValue;
    private TotemDollArmsType standardTotemDollArmsType;
    private Vec2i tagButtonPos;
    private boolean useVanillaTotemModel;
    private int betterTagMenuTooltipSize;
    private float tagMenuTooltipModelScale;
    private int parallelTasksCount;
    private boolean firstRun;
    private boolean supportOtherModsTotems;

    private MyTotemDollConfig() {
        throw new IllegalArgumentException();
    }

    public static MyTotemDollConfig getInstance() {
        return INSTANCE == null ? MyTotemDollConfig.reload() : INSTANCE;
    }

    public static MyTotemDollConfig reload() {
        INSTANCE = MyTotemDollConfig.read();
        return INSTANCE;
    }

    public static MyTotemDollConfig getNewInstance() {
        return CodecUtils.parseNewInstanceHacky(CODEC);
    }

    private static MyTotemDollConfig read() {
        return ConfigUtils.readConfig(CODEC, CONFIG_FILE, LOGGER);
    }

    public void saveAsync() {
        CompletableFuture.runAsync(this::save);
    }

    public void save() {
        ConfigUtils.saveConfig(this, CODEC, CONFIG_FILE, LOGGER);
    }

    @Generated
    public boolean isModEnabled() {
        return this.modEnabled;
    }

    @Generated
    public boolean isDebugLogEnabled() {
        return this.debugLogEnabled;
    }

    @Generated
    public RenderingConfig getRenderingConfig() {
        return this.renderingConfig;
    }

    @Generated
    public String getStandardTotemDollSkinValue() {
        return this.standardTotemDollSkinValue;
    }

    @Generated
    public TotemDollSkinType getStandardTotemDollSkinType() {
        return this.standardTotemDollSkinType;
    }

    @Generated
    public class_2960 getStandardTotemDollModelValue() {
        return this.standardTotemDollModelValue;
    }

    @Generated
    public TotemDollArmsType getStandardTotemDollArmsType() {
        return this.standardTotemDollArmsType;
    }

    @Generated
    public Vec2i getTagButtonPos() {
        return this.tagButtonPos;
    }

    @Generated
    public boolean isUseVanillaTotemModel() {
        return this.useVanillaTotemModel;
    }

    @Generated
    public int getBetterTagMenuTooltipSize() {
        return this.betterTagMenuTooltipSize;
    }

    @Generated
    public float getTagMenuTooltipModelScale() {
        return this.tagMenuTooltipModelScale;
    }

    @Generated
    public int getParallelTasksCount() {
        return this.parallelTasksCount;
    }

    @Generated
    public boolean isFirstRun() {
        return this.firstRun;
    }

    @Generated
    public boolean isSupportOtherModsTotems() {
        return this.supportOtherModsTotems;
    }

    @Generated
    public void setModEnabled(boolean modEnabled) {
        this.modEnabled = modEnabled;
    }

    @Generated
    public void setDebugLogEnabled(boolean debugLogEnabled) {
        this.debugLogEnabled = debugLogEnabled;
    }

    @Generated
    public void setRenderingConfig(RenderingConfig renderingConfig) {
        this.renderingConfig = renderingConfig;
    }

    @Generated
    public void setStandardTotemDollSkinValue(String standardTotemDollSkinValue) {
        this.standardTotemDollSkinValue = standardTotemDollSkinValue;
    }

    @Generated
    public void setStandardTotemDollSkinType(TotemDollSkinType standardTotemDollSkinType) {
        this.standardTotemDollSkinType = standardTotemDollSkinType;
    }

    @Generated
    public void setStandardTotemDollModelValue(class_2960 standardTotemDollModelValue) {
        this.standardTotemDollModelValue = standardTotemDollModelValue;
    }

    @Generated
    public void setStandardTotemDollArmsType(TotemDollArmsType standardTotemDollArmsType) {
        this.standardTotemDollArmsType = standardTotemDollArmsType;
    }

    @Generated
    public void setTagButtonPos(Vec2i tagButtonPos) {
        this.tagButtonPos = tagButtonPos;
    }

    @Generated
    public void setUseVanillaTotemModel(boolean useVanillaTotemModel) {
        this.useVanillaTotemModel = useVanillaTotemModel;
    }

    @Generated
    public void setBetterTagMenuTooltipSize(int betterTagMenuTooltipSize) {
        this.betterTagMenuTooltipSize = betterTagMenuTooltipSize;
    }

    @Generated
    public void setTagMenuTooltipModelScale(float tagMenuTooltipModelScale) {
        this.tagMenuTooltipModelScale = tagMenuTooltipModelScale;
    }

    @Generated
    public void setParallelTasksCount(int parallelTasksCount) {
        this.parallelTasksCount = parallelTasksCount;
    }

    @Generated
    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    @Generated
    public void setSupportOtherModsTotems(boolean supportOtherModsTotems) {
        this.supportOtherModsTotems = supportOtherModsTotems;
    }

    @Generated
    public MyTotemDollConfig(boolean modEnabled, boolean debugLogEnabled, RenderingConfig renderingConfig, String standardTotemDollSkinValue, TotemDollSkinType standardTotemDollSkinType, class_2960 standardTotemDollModelValue, TotemDollArmsType standardTotemDollArmsType, Vec2i tagButtonPos, boolean useVanillaTotemModel, int betterTagMenuTooltipSize, float tagMenuTooltipModelScale, int parallelTasksCount, boolean firstRun, boolean supportOtherModsTotems) {
        this.modEnabled = modEnabled;
        this.debugLogEnabled = debugLogEnabled;
        this.renderingConfig = renderingConfig;
        this.standardTotemDollSkinValue = standardTotemDollSkinValue;
        this.standardTotemDollSkinType = standardTotemDollSkinType;
        this.standardTotemDollModelValue = standardTotemDollModelValue;
        this.standardTotemDollArmsType = standardTotemDollArmsType;
        this.tagButtonPos = tagButtonPos;
        this.useVanillaTotemModel = useVanillaTotemModel;
        this.betterTagMenuTooltipSize = betterTagMenuTooltipSize;
        this.tagMenuTooltipModelScale = tagMenuTooltipModelScale;
        this.parallelTasksCount = parallelTasksCount;
        this.firstRun = firstRun;
        this.supportOtherModsTotems = supportOtherModsTotems;
    }
}

