/*
 * Decompiled with CFR 0.152.
 */
package com.pm777.createimmersiveunnecessaryshaft;

import blusunrize.immersiveengineering.api.energy.IRotationAcceptor;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillBlockEntity;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import com.pm777.createimmersiveunnecessaryshaft.TreatedWoodShaft;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TreatedWoodShaftEntity
extends GeneratingKineticBlockEntity {
    private final CapabilityReference<IRotationAcceptor> outputCapPlus;
    public final BlockPos neighborPosPlus;
    private final CapabilityReference<IRotationAcceptor> outputCapMinus;
    public final BlockPos neighborPosMinus;
    private final ResettableCapability<IRotationAcceptor> inputCap;
    private float generatedSpeed;
    private float addedCapacity;
    private float impact;
    public int ticksSinceUpdate;

    public TreatedWoodShaftEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        Direction plus = Direction.m_122387_((Direction.Axis)((Direction.Axis)this.m_58900_().m_61143_((Property)TreatedWoodShaft.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        this.outputCapPlus = CapabilityReference.forNeighbor((BlockEntity)this, (Capability)IRotationAcceptor.CAPABILITY, () -> plus);
        this.neighborPosPlus = new DirectionalBlockPos(this.m_58899_().m_121945_(plus), plus.m_122424_()).position();
        Direction minus = Direction.m_122387_((Direction.Axis)((Direction.Axis)this.m_58900_().m_61143_((Property)TreatedWoodShaft.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE);
        this.outputCapMinus = CapabilityReference.forNeighbor((BlockEntity)this, (Capability)IRotationAcceptor.CAPABILITY, () -> minus);
        this.neighborPosMinus = new DirectionalBlockPos(this.m_58899_().m_121945_(minus), plus.m_122424_()).position();
        this.inputCap = this.registerCapability(new SpecialRotationAcceptor());
        this.generatedSpeed = 0.0f;
        this.addedCapacity = 0.0f;
        this.impact = 0.0f;
        this.ticksSinceUpdate = 0;
    }

    protected <T> ResettableCapability<T> registerCapability(T val) {
        return new ResettableCapability(val);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == IRotationAcceptor.CAPABILITY && ((Direction.Axis)this.m_58900_().m_61143_((Property)TreatedWoodShaft.AXIS)).test(side) ? this.inputCap.cast() : super.getCapability(cap, side);
    }

    public void tick() {
        super.tick();
        if (this.speed != 0.0f) {
            IRotationAcceptor dynamo = (IRotationAcceptor)this.outputCapPlus.getNullable();
            if (dynamo == null || dynamo instanceof SpecialRotationAcceptor) {
                dynamo = (IRotationAcceptor)this.outputCapMinus.getNullable();
            }
            if (dynamo != null && !(dynamo instanceof SpecialRotationAcceptor)) {
                float new_impact = this.impact + (this.capacity - this.stress) / Mth.m_14154_((float)this.speed);
                new_impact = new_impact > 80000.0f / Mth.m_14154_((float)this.speed) ? 80000.0f / Mth.m_14154_((float)this.speed) : (new_impact < 0.0f ? 0.0f : new_impact);
                dynamo.inputRotation((double)(this.impact / 90.0f));
                if (this.impact != new_impact) {
                    this.impact = new_impact;
                    this.updateGeneratedRotation();
                    this.m_6596_();
                }
            }
            ++this.ticksSinceUpdate;
            if (this.ticksSinceUpdate > 20) {
                this.generatedSpeed = 0.0f;
                this.addedCapacity = 0.0f;
                this.ticksSinceUpdate = 0;
                this.updateGeneratedRotation();
                this.m_6596_();
            }
        } else {
            this.impact = 0.0f;
        }
        this.sendData();
    }

    private void updateFromInput(BlockEntity BE, float rotation) {
        if (BE instanceof IEBaseBlockEntity) {
            if (BE instanceof WatermillBlockEntity) {
                this.generatedSpeed = (float)(((WatermillBlockEntity)BE).perTick * 1200.0);
            }
            if (BE instanceof WindmillBlockEntity) {
                this.generatedSpeed = rotation * 1200.0f / 800.0f;
            }
            if (this.addedCapacity != rotation * 90.0f) {
                this.addedCapacity = rotation * 90.0f;
                this.updateGeneratedRotation();
            }
            this.ticksSinceUpdate = 0;
        }
    }

    public float calculateAddedStressCapacity() {
        this.lastCapacityProvided = this.addedCapacity;
        return this.addedCapacity;
    }

    public float calculateStressApplied() {
        this.lastStressApplied = this.impact;
        return this.impact;
    }

    public float getGeneratedSpeed() {
        return this.generatedSpeed;
    }

    private class SpecialRotationAcceptor
    implements IRotationAcceptor {
        private SpecialRotationAcceptor() {
        }

        public void inputRotation(double rotation) {
            Level currWorld = TreatedWoodShaftEntity.this.m_58904_();
            if (currWorld != null) {
                TreatedWoodShaftEntity.this.updateFromInput(SafeChunkUtils.getSafeBE((LevelAccessor)currWorld, (BlockPos)TreatedWoodShaftEntity.this.neighborPosPlus), (float)rotation);
                TreatedWoodShaftEntity.this.updateFromInput(SafeChunkUtils.getSafeBE((LevelAccessor)currWorld, (BlockPos)TreatedWoodShaftEntity.this.neighborPosMinus), (float)rotation);
            }
        }
    }
}

