/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.registry;

import com.thedeathlycow.novoatlas.world.gen.MapImage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class MultiFileTypeToIdConverter {
    private final String prefix;
    private final String[] extensions;

    public MultiFileTypeToIdConverter(String prefix, String[] extensions) {
        this.prefix = prefix;
        this.extensions = extensions;
    }

    public static MultiFileTypeToIdConverter builtinImages(String prefix) {
        String[] extensions = (String[])Arrays.stream(ImageIO.getReaderFileSuffixes()).map(suffix -> "." + suffix).toArray(String[]::new);
        return new MultiFileTypeToIdConverter(prefix, extensions);
    }

    public static MultiFileTypeToIdConverter imageRegistry(class_5321<class_2378<MapImage>> registryKey) {
        return MultiFileTypeToIdConverter.builtinImages(MultiFileTypeToIdConverter.getElementsPath(registryKey));
    }

    public class_2960 fileToId(class_2960 file) {
        String path = file.method_12832();
        for (String extension : this.extensions) {
            if (!path.endsWith(extension)) continue;
            return file.method_45136(path.substring(this.prefix.length() + 1, path.length() - extension.length()));
        }
        String message = "Unknown image format '%s', supported formats are: %s".formatted(path, Arrays.toString(this.extensions));
        throw new IllegalArgumentException(message);
    }

    public Map<class_2960, class_3298> listMatchingResources(class_3300 resourceManager) {
        return resourceManager.method_14488(this.prefix, this::test);
    }

    public Map<class_2960, List<class_3298>> listMatchingResourceStacks(class_3300 resourceManager) {
        return resourceManager.method_41265(this.prefix, this::test);
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    private boolean test(class_2960 location) {
        return Arrays.stream(this.extensions).anyMatch(extension -> location.method_12832().endsWith((String)extension));
    }

    private static String getElementsPath(class_5321<? extends class_2378<?>> registryKey) {
        String namespace = registryKey.method_29177().method_12836();
        if (namespace.equals("minecraft")) {
            return class_7924.method_60915(registryKey);
        }
        return "%s/%s".formatted(namespace, registryKey.method_29177().method_12832());
    }
}

