/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.registry.ImageManager;
import com.thedeathlycow.novoatlas.registry.NovoAtlasResourceKeys;
import com.thedeathlycow.novoatlas.world.gen.MapImage;
import com.thedeathlycow.novoatlas.world.gen.MapScaleConfig;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.ColorMapBiomeProvider;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.LayeredMapBiomeProvider;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MapInfo(class_5321<MapImage> heightMap, Optional<class_5321<MapImage>> fluidHeightMap, ColorMapBiomeProvider surfaceBiomes, Optional<LayeredMapBiomeProvider> caveBiomes, int startingY, int surfaceRange, Optional<MapScaleConfig> scaling) {
    public static final Codec<MapInfo> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5321.method_39154(NovoAtlasResourceKeys.HEIGHTMAP).fieldOf("height_map").forGetter(MapInfo::heightMap), (App)class_5321.method_39154(NovoAtlasResourceKeys.HEIGHTMAP).optionalFieldOf("fluid_height_map").forGetter(MapInfo::fluidHeightMap), (App)ColorMapBiomeProvider.CODEC.codec().fieldOf("surface_biomes").forGetter(MapInfo::surfaceBiomes), (App)LayeredMapBiomeProvider.CODEC.codec().optionalFieldOf("cave_biomes").forGetter(MapInfo::caveBiomes), (App)Codec.INT.fieldOf("starting_y").forGetter(MapInfo::startingY), (App)class_5699.field_33442.optionalFieldOf("surface_range", (Object)16).forGetter(MapInfo::surfaceRange), (App)MapScaleConfig.CODEC.optionalFieldOf("scaling").forGetter(MapInfo::scaling)).apply((Applicative)instance, MapInfo::new));
    public static final Codec<class_6880<MapInfo>> CODEC = class_5381.method_29749(NovoAtlasResourceKeys.MAP_INFO, DIRECT_CODEC);

    public static MapImage lookupHeightmap(class_5321<MapImage> map) {
        return Objects.requireNonNull(ImageManager.HEIGHTMAP.getImage(map), "Missing height map image " + String.valueOf(map));
    }

    public static MapImage lookupBiomeMap(class_5321<MapImage> map) {
        return Objects.requireNonNull(ImageManager.BIOME_MAP.getImage(map), "Missing biome map image " + String.valueOf(map));
    }

    public int getHeightMapElevation(int x, int z, int fallback) {
        return MapInfo.lookupHeightmap(this.heightMap).sample(x, z, this, fallback);
    }

    public int getFluidHeightMapElevation(int x, int z, int seaLevel) {
        if (this.fluidHeightMap.isPresent()) {
            return MapInfo.lookupHeightmap(this.fluidHeightMap.orElseThrow()).sample(x, z, this, seaLevel);
        }
        return seaLevel;
    }

    public int getHeightMapElevation(int x, int z) {
        return MapInfo.lookupHeightmap(this.heightMap).sample(x, z, this);
    }

    @NotNull
    public class_6880<class_1959> getBiome(int x, int y, int z, @NotNull class_6880<class_1959> defaultBiome) {
        class_6880<class_1959> caveBiome;
        if (this.caveBiomes.isPresent() && (caveBiome = this.getCaveBiome(x, y, z, this.caveBiomes.orElseThrow())) != null) {
            return caveBiome;
        }
        class_6880<class_1959> surfaceBiome = this.surfaceBiomes.getBiome(x, y, z, this);
        return surfaceBiome != null ? surfaceBiome : defaultBiome;
    }

    public MapScaleConfig.HorizontalConfig horizontalScale() {
        if (this.scaling.isPresent()) {
            return this.scaling.orElseThrow().horizontalScale();
        }
        return MapScaleConfig.HorizontalConfig.DEFAULT;
    }

    public float verticalScale() {
        if (this.scaling.isPresent()) {
            return this.scaling.orElseThrow().verticalScale();
        }
        return 1.0f;
    }

    @Nullable
    private class_6880<class_1959> getCaveBiome(int x, int y, int z, LayeredMapBiomeProvider caveBiomes) {
        class_6880<class_1959> caveBiome;
        int height = this.getHeightMapElevation(x, z, Integer.MIN_VALUE);
        if (height == Integer.MIN_VALUE) {
            return null;
        }
        if (y <= height - this.surfaceRange && (caveBiome = caveBiomes.getBiome(x, y, z, this)) != null) {
            return caveBiome;
        }
        return null;
    }
}

