/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.biome.ColorHelper;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_6880;

public record BiomeColorEntry(class_6880<class_1959> biome, int color) {
    public static final Codec<BiomeColorEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1959.field_24677.fieldOf("biome").forGetter(BiomeColorEntry::biome), (App)ColorHelper.CODEC.fieldOf("color").forGetter(BiomeColorEntry::color)).apply((Applicative)instance, BiomeColorEntry::new));
    public static final Codec<List<BiomeColorEntry>> LIST_CODEC = CODEC.listOf().validate(BiomeColorEntry::validateList);

    private static DataResult<List<BiomeColorEntry>> validateList(List<BiomeColorEntry> entries) {
        if (entries.isEmpty()) {
            return DataResult.error(() -> "Biome color list may not be empty");
        }
        IntArraySet colors = new IntArraySet();
        for (BiomeColorEntry entry : entries) {
            if (colors.contains(entry.color)) {
                return DataResult.error(() -> String.format("Found duplicate color #%1$06x (%1$d) found for biome %2$s", entry.color, entry.biome));
            }
            colors.add(entry.color);
        }
        return DataResult.success(entries);
    }
}

