/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DensityFunction;

public record GetHeightFromMapDensityFunction(Holder<MapInfo> mapInfo, int lowerBound, int upperBound) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<GetHeightFromMapDensityFunction> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapInfo.CODEC.fieldOf("map_info").forGetter(GetHeightFromMapDensityFunction::mapInfo), (App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("lower_bound").forGetter(GetHeightFromMapDensityFunction::lowerBound), (App)Codec.intRange((int)(DimensionType.MIN_Y * 2), (int)(DimensionType.MAX_Y * 2)).fieldOf("upper_bound").forGetter(GetHeightFromMapDensityFunction::upperBound)).apply((Applicative)instance, GetHeightFromMapDensityFunction::new)).validate(df -> {
        if (df.upperBound < df.lowerBound) {
            return DataResult.error(() -> "Upper bound " + df.upperBound + " is less than lower bound " + df.lowerBound);
        }
        return DataResult.success((Object)df);
    });
    public static final KeyDispatchDataCodec<GetHeightFromMapDensityFunction> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);

    public double compute(DensityFunction.FunctionContext context) {
        int elevation = ((MapInfo)this.mapInfo.value()).getHeightMapElevation(context.blockX(), context.blockZ(), Integer.MIN_VALUE);
        return Mth.clamp((int)elevation, (int)this.lowerBound, (int)this.upperBound);
    }

    public double minValue() {
        return this.lowerBound;
    }

    public double maxValue() {
        return this.upperBound;
    }

    public KeyDispatchDataCodec<? extends GetHeightFromMapDensityFunction> codec() {
        return CODEC;
    }
}

