/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.mixin.accessor.NoiseBasedChunkGeneratorAccessor;
import com.thedeathlycow.novoatlas.mixin.accessor.NoiseChunkAccessor;
import com.thedeathlycow.novoatlas.world.gen.GetHeightFromMapDensityFunction;
import com.thedeathlycow.novoatlas.world.gen.HeightmapDensityFunction;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ImageMapChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<ImageMapChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(ChunkGenerator::getBiomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings), (App)MapInfo.CODEC.fieldOf("map_info").forGetter(ImageMapChunkGenerator::getMapInfo), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("underground_density_function").forGetter(ImageMapChunkGenerator::getUndergroundDensityFunction), (App)Codec.BOOL.optionalFieldOf("enable_carvers", (Object)true).forGetter(ImageMapChunkGenerator::isEnableCarvers)).apply((Applicative)instance, ImageMapChunkGenerator::new));
    private final Holder<MapInfo> mapInfo;
    private final DensityFunction undergroundDensityFunction;
    private final boolean enableCarvers;

    public ImageMapChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, Holder<MapInfo> mapInfo, DensityFunction undergroundDensityFunction, boolean enableCarvers) {
        super(biomeSource, ImageMapChunkGenerator.applyHeightMapToDensityFunctions(settings, mapInfo, undergroundDensityFunction));
        this.mapInfo = mapInfo;
        this.undergroundDensityFunction = undergroundDensityFunction;
        this.enableCarvers = enableCarvers;
        ((NoiseBasedChunkGeneratorAccessor)((Object)this)).novoatlas$setGlobalFluidPicker((Supplier<Aquifer.FluidPicker>)Suppliers.memoize(() -> this.pickFluid((NoiseGeneratorSettings)settings.value())));
    }

    private Aquifer.FluidPicker pickFluid(NoiseGeneratorSettings settings) {
        Aquifer.FluidStatus lava = new Aquifer.FluidStatus(-54, Blocks.LAVA.defaultBlockState());
        int seaLevel = settings.seaLevel();
        Aquifer.FluidStatus air = new Aquifer.FluidStatus(DimensionType.MIN_Y * 2, Blocks.AIR.defaultBlockState());
        return (x, y, z) -> {
            if (SharedConstants.DEBUG_DISABLE_FLUID_GENERATION) {
                return air;
            }
            if (y < Math.min(-54, seaLevel)) {
                return lava;
            }
            return new Aquifer.FluidStatus(this.sampleFluidElevation(x, z), settings.defaultFluid());
        };
    }

    private static Holder<NoiseGeneratorSettings> applyHeightMapToDensityFunctions(Holder<NoiseGeneratorSettings> settings, Holder<MapInfo> mapInfo, DensityFunction undergroundDensityFunction) {
        NoiseGeneratorSettings baseSettings = (NoiseGeneratorSettings)settings.value();
        NoiseRouter baseNoiseRouter = baseSettings.noiseRouter();
        HeightmapDensityFunction heightMap = new HeightmapDensityFunction(mapInfo);
        NoiseSettings noiseSettings = baseSettings.noiseSettings();
        int minY = noiseSettings.minY();
        int maxY = minY + noiseSettings.height();
        GetHeightFromMapDensityFunction preliminaryHeightmap = new GetHeightFromMapDensityFunction(mapInfo, minY, maxY);
        DensityFunction finalDensity = DensityFunctions.min((DensityFunction)undergroundDensityFunction, (DensityFunction)heightMap);
        NoiseRouter fixedNoiseRouter = new NoiseRouter(baseNoiseRouter.barrierNoise(), baseNoiseRouter.fluidLevelFloodednessNoise(), baseNoiseRouter.fluidLevelSpreadNoise(), baseNoiseRouter.lavaNoise(), baseNoiseRouter.temperature(), baseNoiseRouter.vegetation(), baseNoiseRouter.continents(), baseNoiseRouter.erosion(), baseNoiseRouter.depth(), baseNoiseRouter.ridges(), (DensityFunction)preliminaryHeightmap, finalDensity, baseNoiseRouter.veinToggle(), baseNoiseRouter.veinRidged(), baseNoiseRouter.veinGap());
        NoiseGeneratorSettings fixedSettings = new NoiseGeneratorSettings(baseSettings.noiseSettings(), baseSettings.defaultBlock(), baseSettings.defaultFluid(), fixedNoiseRouter, baseSettings.surfaceRule(), baseSettings.spawnTarget(), baseSettings.seaLevel(), baseSettings.disableMobGeneration(), baseSettings.aquifersEnabled(), baseSettings.oreVeinsEnabled(), baseSettings.useLegacyRandomSource());
        return Holder.direct((Object)fixedSettings);
    }

    protected MapCodec<? extends ImageMapChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk) {
        if (this.enableCarvers) {
            super.applyCarvers(level, seed, random, biomeManager, structureManager, chunk);
        }
    }

    public int getBaseHeight(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.sampleElevation(x, z);
    }

    protected ChunkAccess doFill(Blender blender, StructureManager structureManager, RandomState randomState, ChunkAccess chunkAccess, int minCellY, int noiseCellCount) {
        NoiseChunk noiseChunk = chunkAccess.getOrCreateNoiseChunk(c -> this.createNoiseChunk((ChunkAccess)c, structureManager, blender, randomState));
        NoiseChunkAccessor noiseChunkAccessor = (NoiseChunkAccessor)noiseChunk;
        Heightmap oceanFloor = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap worldSurface = chunkAccess.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunkAccess.getPos();
        int chunkBlockX = chunkPos.getMinBlockX();
        int chunkBlockZ = chunkPos.getMinBlockZ();
        Aquifer aquifer = noiseChunk.aquifer();
        noiseChunk.initializeForFirstCellX();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int cellWidth = noiseChunkAccessor.invokeCellWidth();
        int cellHeight = noiseChunkAccessor.invokeCellHeight();
        int cellsPerChunkX = 16 / cellWidth;
        int cellsPerChunkZ = 16 / cellWidth;
        for (int cellX = 0; cellX < cellsPerChunkX; ++cellX) {
            noiseChunk.advanceCellX(cellX);
            for (int cellZ = 0; cellZ < cellsPerChunkZ; ++cellZ) {
                int section = chunkAccess.getSectionsCount() - 1;
                LevelChunkSection currentSection = chunkAccess.getSection(section);
                for (int cellY = noiseCellCount - 1; cellY >= 0; --cellY) {
                    noiseChunk.selectCellYZ(cellY, cellZ);
                    for (int localY = cellHeight - 1; localY >= 0; --localY) {
                        int absoluteY = (minCellY + cellY) * cellHeight + localY;
                        int localBlockY = absoluteY & 0xF;
                        int sectionIndex = chunkAccess.getSectionIndex(absoluteY);
                        if (section != sectionIndex) {
                            section = sectionIndex;
                            currentSection = chunkAccess.getSection(sectionIndex);
                        }
                        noiseChunk.updateForY(absoluteY, (double)localY / (double)cellHeight);
                        for (int localX = 0; localX < cellWidth; ++localX) {
                            int absoluteX = chunkBlockX + cellX * cellWidth + localX;
                            int localBlockX = absoluteX & 0xF;
                            noiseChunk.updateForX(absoluteX, (double)localX / (double)cellWidth);
                            for (int localZ = 0; localZ < cellWidth; ++localZ) {
                                BlockState state;
                                int absoluteZ = chunkBlockZ + cellZ * cellWidth + localZ;
                                int localBlockZ = absoluteZ & 0xF;
                                noiseChunk.updateForZ(absoluteZ, (double)localZ / (double)cellWidth);
                                int elevation = this.sampleElevation(absoluteX, absoluteZ);
                                if (elevation < this.getMinY() || (state = this.sampleState(noiseChunk)).is(Blocks.AIR) || SharedConstants.debugVoidTerrain((ChunkPos)chunkAccess.getPos())) continue;
                                currentSection.setBlockState(localBlockX, localBlockY, localBlockZ, state, false);
                                oceanFloor.update(localBlockX, absoluteY, localBlockZ, state);
                                worldSurface.update(localBlockX, absoluteY, localBlockZ, state);
                                if (!aquifer.shouldScheduleFluidUpdate() || state.getFluidState().isEmpty()) continue;
                                mutable.set(absoluteX, absoluteY, absoluteZ);
                                chunkAccess.markPosForPostprocessing((BlockPos)mutable);
                            }
                        }
                    }
                }
            }
            noiseChunk.swapSlices();
        }
        noiseChunk.stopInterpolation();
        return chunkAccess;
    }

    private int sampleElevation(int x, int z) {
        return ((MapInfo)this.mapInfo.value()).getHeightMapElevation(x, z, this.getMinY() - 1);
    }

    private int sampleFluidElevation(int x, int z) {
        return ((MapInfo)this.mapInfo.value()).getFluidHeightMapElevation(x, z, this.getSeaLevel());
    }

    @Deprecated
    private double computeBeardDensity(int distanceBelowTop, double finalDensity, DensityFunction beardifier, NoiseChunk noiseChunk) {
        double beard = beardifier.compute((DensityFunction.FunctionContext)noiseChunk);
        if (beard > 0.0) {
            double softening = distanceBelowTop >= 0 ? finalDensity : (double)distanceBelowTop * 0.025;
            return softening + beard;
        }
        return -1.0;
    }

    public Holder<MapInfo> getMapInfo() {
        return this.mapInfo;
    }

    public DensityFunction getUndergroundDensityFunction() {
        return this.undergroundDensityFunction;
    }

    public boolean isEnableCarvers() {
        return this.enableCarvers;
    }

    private BlockState sampleState(NoiseChunk noiseChunk) {
        BlockState state = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
        if (state == null) {
            return this.defaultBlock();
        }
        return state;
    }

    private BlockState defaultFluid() {
        return ((NoiseGeneratorSettings)this.generatorSettings().value()).defaultFluid();
    }

    private BlockState defaultBlock() {
        return ((NoiseGeneratorSettings)this.generatorSettings().value()).defaultBlock();
    }
}

