/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.thedeathlycow.novoatlas.world.gen.MapImage;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum InterpolationStrategy implements StringRepresentable
{
    NEAREST_NEIGHBOR("nearest_neighbor"){

        @Override
        public double interpolate(double x, double z, MapImage image) {
            return image.getTruncated(x, z);
        }
    }
    ,
    BILINEAR("bilinear"){

        @Override
        public double interpolate(double x, double z, MapImage image) {
            int truncatedX = Mth.floor((double)x);
            int truncatedZ = Mth.floor((double)z);
            double deltaX = x - (double)truncatedX;
            double deltaZ = z - (double)truncatedZ;
            int nextX = Math.min(truncatedX + 1, image.width() - 1);
            int nextZ = Math.min(truncatedZ + 1, image.height() - 1);
            int[][] pixels = image.pixels();
            int topLeft = pixels[truncatedX][truncatedZ];
            int topRight = pixels[nextX][truncatedZ];
            int bottomLeft = pixels[truncatedX][nextZ];
            int bottomRight = pixels[nextX][nextZ];
            return Mth.lerp2((double)deltaX, (double)deltaZ, (double)topLeft, (double)topRight, (double)bottomLeft, (double)bottomRight);
        }
    }
    ,
    BICUBIC("bicubic"){

        @Override
        public double interpolate(double x, double z, MapImage image) {
            int truncatedX = Mth.floor((double)x);
            int truncatedZ = Mth.floor((double)z);
            double deltaX = x - (double)truncatedX;
            double deltaZ = z - (double)truncatedZ;
            double[][] p = InterpolationStrategy.cubicNeighborhood(truncatedX, truncatedZ, image);
            double[] arr = new double[]{3.getValue(p[0], deltaZ), 3.getValue(p[1], deltaZ), 3.getValue(p[2], deltaZ), 3.getValue(p[3], deltaZ)};
            return 3.getValue(arr, deltaX);
        }

        private static double getValue(double[] p, double x) {
            return p[1] + 0.5 * x * (p[2] - p[0] + x * (2.0 * p[0] - 5.0 * p[1] + 4.0 * p[2] - p[3] + x * (3.0 * (p[1] - p[2]) + p[3] - p[0])));
        }
    };

    public static final StringRepresentable.EnumCodec<InterpolationStrategy> CODEC;
    private final String name;

    private InterpolationStrategy(String name) {
        this.name = name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public abstract double interpolate(double var1, double var3, MapImage var5);

    private static double[][] cubicNeighborhood(int x, int z, MapImage image) {
        int[][] pixels = image.pixels();
        int width = image.width();
        int height = image.height();
        double[][] G = new double[4][4];
        for (int col = -1; col < 3; ++col) {
            for (int row = -1; row < 3; ++row) {
                int px = Mth.clamp((int)(x + col), (int)0, (int)(width - 1));
                int pz = Mth.clamp((int)(z + row), (int)0, (int)(height - 1));
                G[col + 1][row + 1] = pixels[px][pz];
            }
        }
        return G;
    }

    static {
        CODEC = StringRepresentable.fromEnum(InterpolationStrategy::values);
    }
}

