/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.InterpolationStrategy;
import com.thedeathlycow.novoatlas.world.gen.MapImage;
import net.minecraft.util.ExtraCodecs;

public record MapScaleConfig(float verticalScale, HorizontalConfig horizontalScale) {
    public static final Codec<MapScaleConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("vertical_scale", (Object)Float.valueOf(1.0f)).forGetter(MapScaleConfig::verticalScale), (App)HorizontalConfig.CODEC.optionalFieldOf("horizontal_scale", (Object)HorizontalConfig.DEFAULT).forGetter(MapScaleConfig::horizontalScale)).apply((Applicative)instance, MapScaleConfig::new));

    public record HorizontalConfig(InterpolationStrategy interpolation, float value) {
        public static final HorizontalConfig DEFAULT = new HorizontalConfig(InterpolationStrategy.NEAREST_NEIGHBOR, 1.0f);
        private static final Codec<HorizontalConfig> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)InterpolationStrategy.CODEC.fieldOf("interpolation").forGetter(HorizontalConfig::interpolation), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("value").forGetter(HorizontalConfig::value)).apply((Applicative)instance, HorizontalConfig::new));
        private static final Codec<HorizontalConfig> FLOAT_CODEC = ExtraCodecs.POSITIVE_FLOAT.flatComapMap(HorizontalConfig::new, config -> {
            if (config.interpolation == DEFAULT.interpolation()) {
                return DataResult.success((Object)Float.valueOf(config.value));
            }
            return DataResult.error(() -> "Non-bilinear horizontal config cannot map to float " + String.valueOf(config));
        });
        public static final Codec<HorizontalConfig> CODEC = Codec.withAlternative(BASE_CODEC, FLOAT_CODEC);

        public HorizontalConfig(float value) {
            this(DEFAULT.interpolation(), value);
        }

        public double interpolate(double x, double z, MapImage image) {
            return this.interpolation.interpolate(x, z, image);
        }
    }
}

