/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.LayeredMapBiomeProvider;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import org.jetbrains.annotations.NotNull;

public class ColorMapBiomeSource
extends BiomeSource {
    public static final MapCodec<ColorMapBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapInfo.CODEC.fieldOf("map_info").forGetter(ColorMapBiomeSource::getMapInfo), (App)Biome.CODEC.fieldOf("default_biome").forGetter(ColorMapBiomeSource::getDefaultBiome)).apply((Applicative)instance, ColorMapBiomeSource::new));
    private final Holder<MapInfo> mapInfo;
    private final Holder<Biome> defaultBiome;

    public ColorMapBiomeSource(Holder<MapInfo> mapInfo, Holder<Biome> defaultBiome) {
        this.mapInfo = mapInfo;
        this.defaultBiome = defaultBiome;
    }

    protected MapCodec<? extends ColorMapBiomeSource> codec() {
        return CODEC;
    }

    @NotNull
    protected Stream<Holder<Biome>> collectPossibleBiomes() {
        MapInfo mapInfoValue = (MapInfo)this.mapInfo.value();
        Stream<Holder<Biome>> baseBiomes = mapInfoValue.surfaceBiomes().collectPossibleBiomes();
        Optional<LayeredMapBiomeProvider> caveBiomes = mapInfoValue.caveBiomes();
        if (caveBiomes.isPresent()) {
            baseBiomes = Stream.concat(baseBiomes, mapInfoValue.caveBiomes().orElseThrow().collectPossibleBiomes());
        }
        return Stream.concat(Stream.of(this.defaultBiome), baseBiomes);
    }

    public Holder<Biome> getNoiseBiome(int biomeX, int biomeY, int biomeZ, Climate.Sampler sampler) {
        MapInfo info = (MapInfo)this.mapInfo.value();
        int x = QuartPos.toBlock((int)biomeX);
        int y = QuartPos.toBlock((int)biomeY);
        int z = QuartPos.toBlock((int)biomeZ);
        return info.getBiome(x, y, z, this.defaultBiome);
    }

    public Holder<MapInfo> getMapInfo() {
        return this.mapInfo;
    }

    public Holder<Biome> getDefaultBiome() {
        return this.defaultBiome;
    }
}

