/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.mixin.compat.terrablender.present;

import com.thedeathlycow.novoatlas.world.gen.ImageMapChunkGenerator;
import com.thedeathlycow.novoatlas.world.gen.biome.ColorMapBiomeSource;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import terrablender.api.RegionType;
import terrablender.api.SurfaceRuleManager;
import terrablender.util.LevelUtils;
import terrablender.worldgen.IExtendedNoiseGeneratorSettings;

@Mixin(value={LevelUtils.class})
public abstract class LevelUtilsMixin {
    @Inject(method={"initializeBiomes"}, at={@At(value="HEAD")}, cancellable=true)
    private static void patchSurfaceRulesForColorMapBiomes(RegistryAccess registryAccess, Holder<DimensionType> dimensionType, ResourceKey<LevelStem> levelResourceKey, ChunkGenerator chunkGenerator, long seed, CallbackInfo ci) {
        if (chunkGenerator instanceof ImageMapChunkGenerator) {
            ImageMapChunkGenerator imageMapChunkGenerator = (ImageMapChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings generatorSettings = (NoiseGeneratorSettings)imageMapChunkGenerator.generatorSettings().value();
            if (chunkGenerator.getBiomeSource() instanceof ColorMapBiomeSource) {
                SurfaceRuleManager.RuleCategory ruleCategory;
                RegionType regionType;
                RegionType regionType2 = regionType = LevelUtils.getRegionTypeForDimension(dimensionType);
                int n = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"OVERWORLD", "NETHER"}, (RegionType)regionType2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        SurfaceRuleManager.RuleCategory ruleCategory2 = SurfaceRuleManager.RuleCategory.OVERWORLD;
                        break;
                    }
                    case 1: {
                        SurfaceRuleManager.RuleCategory ruleCategory2 = SurfaceRuleManager.RuleCategory.NETHER;
                        break;
                    }
                    case -1: {
                        SurfaceRuleManager.RuleCategory ruleCategory2 = ruleCategory = null;
                    }
                }
                if (ruleCategory != null) {
                    IExtendedNoiseGeneratorSettings extendedNoiseGeneratorSettings = (IExtendedNoiseGeneratorSettings)generatorSettings;
                    extendedNoiseGeneratorSettings.setRuleCategory(ruleCategory);
                }
            }
            if (chunkGenerator.getBiomeSource() instanceof ColorMapBiomeSource) {
                ci.cancel();
            }
        }
    }
}

