/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.registry;

import com.thedeathlycow.novoatlas.NovoAtlas;
import com.thedeathlycow.novoatlas.registry.MultiFileTypeToIdConverter;
import com.thedeathlycow.novoatlas.registry.NovoAtlasResourceKeys;
import com.thedeathlycow.novoatlas.world.gen.MapImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public final class ImageManager {
    public static final ImageManager HEIGHTMAP = new ImageManager(NovoAtlasResourceKeys.HEIGHTMAP, MapImage.Type.HEIGHTMAP);
    public static final ImageManager BIOME_MAP = new ImageManager(NovoAtlasResourceKeys.BIOME_MAP, MapImage.Type.BIOME_MAP);
    private final ResourceKey<Registry<MapImage>> registryKey;
    private final MapImage.Type type;
    private final Map<ResourceKey<MapImage>, MapImage> registry = new IdentityHashMap<ResourceKey<MapImage>, MapImage>();

    private ImageManager(ResourceKey<Registry<MapImage>> registryKey, MapImage.Type type) {
        this.registryKey = registryKey;
        this.type = type;
    }

    public void reload(ResourceManager resourceManager) {
        IdentityHashMap<ResourceKey, MapImage> updatedRegistry = new IdentityHashMap<ResourceKey, MapImage>();
        MultiFileTypeToIdConverter converter = MultiFileTypeToIdConverter.imageRegistry(this.registryKey);
        if (NovoAtlas.LOGGER.isInfoEnabled()) {
            NovoAtlas.LOGGER.info("Reloading map images for {}, supported image formats are: {}", (Object)this.registryKey.location(), (Object)Arrays.toString(converter.getExtensions()));
        }
        Map<ResourceLocation, Resource> resources = converter.listMatchingResources(resourceManager);
        for (Map.Entry<ResourceLocation, Resource> entry : resources.entrySet()) {
            BufferedImage image;
            try (InputStream stream = entry.getValue().open();){
                image = ImageIO.read(stream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            MapImage map = MapImage.fromBufferedImage(image, this.type);
            ResourceKey key = ResourceKey.create(this.registryKey, (ResourceLocation)converter.fileToId(entry.getKey()));
            if (updatedRegistry.put(key, map) == null) continue;
            String message = "Found duplicate image files for {}, overriding with {} (images of the different types should have different names)";
            NovoAtlas.LOGGER.warn("Found duplicate image files for {}, overriding with {} (images of the different types should have different names)", (Object)key.location(), (Object)entry.getKey());
        }
        this.registry.clear();
        this.registry.putAll(updatedRegistry);
        NovoAtlas.LOGGER.info("Loaded {} map image(s) for {}", (Object)this.registry.size(), (Object)this.registryKey.location());
    }

    @Nullable
    public MapImage getImage(ResourceKey<MapImage> key) {
        return this.registry.get(key);
    }
}

