/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import net.minecraft.core.Holder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record HeightmapDensityFunction(Holder<MapInfo> mapInfo, double transitionRange) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<HeightmapDensityFunction> DATA_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapInfo.CODEC.fieldOf("map_info").forGetter(HeightmapDensityFunction::mapInfo), (App)Codec.DOUBLE.optionalFieldOf("transition_range", (Object)10.0).forGetter(HeightmapDensityFunction::transitionRange)).apply((Applicative)instance, HeightmapDensityFunction::new));
    public static final KeyDispatchDataCodec<HeightmapDensityFunction> CODEC = KeyDispatchDataCodec.of(DATA_CODEC);

    public HeightmapDensityFunction(Holder<MapInfo> mapInfo) {
        this(mapInfo, 10.0);
    }

    public double compute(DensityFunction.FunctionContext context) {
        int elevation = ((MapInfo)this.mapInfo.value()).getHeightMapElevation(context.blockX(), context.blockZ(), Integer.MIN_VALUE);
        if (elevation == Integer.MIN_VALUE) {
            return -1.0;
        }
        int yOffset = elevation - context.blockY();
        return Mth.clampedMap((double)yOffset, (double)(-this.transitionRange), (double)this.transitionRange, (double)-1.0, (double)1.0);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC;
    }
}

