/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.registry;

import com.thedeathlycow.novoatlas.NovoAtlas;
import com.thedeathlycow.novoatlas.registry.MultiFileTypeToIdConverter;
import com.thedeathlycow.novoatlas.registry.NovoAtlasResourceKeys;
import com.thedeathlycow.novoatlas.world.gen.MapImage;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class ImageManager {
    public static final ImageManager HEIGHTMAP = new ImageManager(NovoAtlasResourceKeys.HEIGHTMAP, MapImage.Type.HEIGHTMAP);
    public static final ImageManager BIOME_MAP = new ImageManager(NovoAtlasResourceKeys.BIOME_MAP, MapImage.Type.BIOME_MAP);
    private final class_5321<class_2378<MapImage>> registryKey;
    private final MapImage.Type type;
    private final Map<class_5321<MapImage>, MapImage> registry = new IdentityHashMap<class_5321<MapImage>, MapImage>();

    private ImageManager(class_5321<class_2378<MapImage>> registryKey, MapImage.Type type) {
        this.registryKey = registryKey;
        this.type = type;
    }

    public void reload(class_3300 resourceManager) {
        IdentityHashMap<class_5321, MapImage> updatedRegistry = new IdentityHashMap<class_5321, MapImage>();
        MultiFileTypeToIdConverter converter = MultiFileTypeToIdConverter.imageRegistry(this.registryKey);
        if (NovoAtlas.LOGGER.isInfoEnabled()) {
            NovoAtlas.LOGGER.info("Reloading map images for {}, supported image formats are: {}", (Object)this.registryKey.method_29177(), (Object)Arrays.toString(converter.getExtensions()));
        }
        Map<class_2960, class_3298> resources = converter.listMatchingResources(resourceManager);
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            BufferedImage image;
            try (InputStream stream = entry.getValue().method_14482();){
                image = ImageIO.read(stream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            MapImage map = MapImage.fromBufferedImage(image, this.type);
            class_5321 key = class_5321.method_29179(this.registryKey, (class_2960)converter.fileToId(entry.getKey()));
            if (updatedRegistry.put(key, map) == null) continue;
            String message = "Found duplicate image files for {}, overriding with {} (images of the different types should have different names)";
            NovoAtlas.LOGGER.warn("Found duplicate image files for {}, overriding with {} (images of the different types should have different names)", (Object)key.method_29177(), (Object)entry.getKey());
        }
        this.registry.clear();
        this.registry.putAll(updatedRegistry);
        NovoAtlas.LOGGER.info("Loaded {} map image(s) for {}", (Object)this.registry.size(), (Object)this.registryKey.method_29177());
    }

    @Nullable
    public MapImage getImage(class_5321<MapImage> key) {
        return this.registry.get(key);
    }
}

