/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.mixin.accessor.NoiseChunkAccessor;
import com.thedeathlycow.novoatlas.world.gen.HeightmapDensityFunction;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5539;
import net.minecraft.class_6350;
import net.minecraft.class_6568;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7138;

public class ImageMapChunkGenerator
extends class_3754 {
    public static final MapCodec<ImageMapChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541), (App)MapInfo.CODEC.fieldOf("map_info").forGetter(ImageMapChunkGenerator::getMapInfo), (App)class_6910.field_37059.fieldOf("underground_density_function").forGetter(ImageMapChunkGenerator::getUndergroundDensityFunction), (App)Codec.BOOL.optionalFieldOf("enable_carvers", (Object)true).forGetter(ImageMapChunkGenerator::isEnableCarvers)).apply((Applicative)instance, ImageMapChunkGenerator::new));
    private final class_6880<MapInfo> mapInfo;
    private final class_6910 undergroundDensityFunction;
    private final boolean enableCarvers;

    public ImageMapChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings, class_6880<MapInfo> mapInfo, class_6910 undergroundDensityFunction, boolean enableCarvers) {
        super(biomeSource, ImageMapChunkGenerator.applyHeightMapToDensityFunctions(settings, mapInfo, undergroundDensityFunction));
        this.mapInfo = mapInfo;
        this.undergroundDensityFunction = undergroundDensityFunction;
        this.enableCarvers = enableCarvers;
    }

    private static class_6880<class_5284> applyHeightMapToDensityFunctions(class_6880<class_5284> settings, class_6880<MapInfo> mapInfo, class_6910 undergroundDensityFunction) {
        class_5284 baseSettings = (class_5284)settings.comp_349();
        class_6953 baseNoiseRouter = baseSettings.comp_477();
        HeightmapDensityFunction heightMap = new HeightmapDensityFunction(mapInfo);
        class_6910 finalDensity = class_6916.method_40505((class_6910)undergroundDensityFunction, (class_6910)heightMap);
        class_6953 fixedNoiseRouter = new class_6953(baseNoiseRouter.comp_414(), baseNoiseRouter.comp_415(), baseNoiseRouter.comp_416(), baseNoiseRouter.comp_417(), baseNoiseRouter.comp_420(), baseNoiseRouter.comp_539(), baseNoiseRouter.comp_484(), baseNoiseRouter.comp_423(), baseNoiseRouter.comp_424(), baseNoiseRouter.comp_485(), (class_6910)heightMap, finalDensity, baseNoiseRouter.comp_428(), baseNoiseRouter.comp_429(), baseNoiseRouter.comp_430());
        class_5284 fixedSettings = new class_5284(baseSettings.comp_474(), baseSettings.comp_475(), baseSettings.comp_476(), fixedNoiseRouter, baseSettings.comp_478(), baseSettings.comp_538(), baseSettings.comp_479(), baseSettings.comp_480(), baseSettings.comp_481(), baseSettings.comp_482(), baseSettings.comp_483());
        return class_6880.method_40223((Object)fixedSettings);
    }

    protected MapCodec<? extends ImageMapChunkGenerator> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 level, long seed, class_7138 random, class_4543 biomeManager, class_5138 structureManager, class_2791 chunk) {
        if (this.enableCarvers) {
            super.method_12108(level, seed, random, biomeManager, structureManager, chunk);
        }
    }

    public int method_16397(int x, int z, class_2902.class_2903 types, class_5539 levelHeightAccessor, class_7138 randomState) {
        return this.sampleElevation(x, z);
    }

    protected class_2791 method_33754(class_6748 blender, class_5138 structureManager, class_7138 randomState, class_2791 chunkAccess, int minCellY, int noiseCellCount) {
        class_6568 noiseChunk = chunkAccess.method_38255(c -> this.method_41537((class_2791)c, structureManager, blender, randomState));
        NoiseChunkAccessor noiseChunkAccessor = (NoiseChunkAccessor)noiseChunk;
        class_2902 oceanFloor = chunkAccess.method_12032(class_2902.class_2903.field_13195);
        class_2902 worldSurface = chunkAccess.method_12032(class_2902.class_2903.field_13194);
        class_1923 chunkPos = chunkAccess.method_12004();
        int chunkBlockX = chunkPos.method_8326();
        int chunkBlockZ = chunkPos.method_8328();
        class_6350 aquifer = noiseChunk.method_38354();
        noiseChunk.method_38336();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int cellWidth = noiseChunkAccessor.invokeCellWidth();
        int cellHeight = noiseChunkAccessor.invokeCellHeight();
        int cellsPerChunkX = 16 / cellWidth;
        int cellsPerChunkZ = 16 / cellWidth;
        for (int cellX = 0; cellX < cellsPerChunkX; ++cellX) {
            noiseChunk.method_38339(cellX);
            for (int cellZ = 0; cellZ < cellsPerChunkZ; ++cellZ) {
                int section = chunkAccess.method_32890() - 1;
                class_2826 currentSection = chunkAccess.method_38259(section);
                for (int cellY = noiseCellCount - 1; cellY >= 0; --cellY) {
                    noiseChunk.method_38362(cellY, cellZ);
                    for (int localY = cellHeight - 1; localY >= 0; --localY) {
                        int absoluteY = (minCellY + cellY) * cellHeight + localY;
                        int localBlockY = absoluteY & 0xF;
                        int sectionIndex = chunkAccess.method_31602(absoluteY);
                        if (section != sectionIndex) {
                            section = sectionIndex;
                            currentSection = chunkAccess.method_38259(sectionIndex);
                        }
                        noiseChunk.method_38337(absoluteY, (double)localY / (double)cellHeight);
                        for (int localX = 0; localX < cellWidth; ++localX) {
                            int absoluteX = chunkBlockX + cellX * cellWidth + localX;
                            int localBlockX = absoluteX & 0xF;
                            noiseChunk.method_38349(absoluteX, (double)localX / (double)cellWidth);
                            for (int localZ = 0; localZ < cellWidth; ++localZ) {
                                class_2680 state;
                                int absoluteZ = chunkBlockZ + cellZ * cellWidth + localZ;
                                int localBlockZ = absoluteZ & 0xF;
                                noiseChunk.method_38355(absoluteZ, (double)localZ / (double)cellWidth);
                                int elevation = this.sampleElevation(absoluteX, absoluteZ);
                                if (elevation < this.method_33730() || (state = this.sampleState(noiseChunk)).method_27852(class_2246.field_10124) || class_155.method_37896((class_1923)chunkAccess.method_12004())) continue;
                                currentSection.method_12256(localBlockX, localBlockY, localBlockZ, state, false);
                                oceanFloor.method_12597(localBlockX, absoluteY, localBlockZ, state);
                                worldSurface.method_12597(localBlockX, absoluteY, localBlockZ, state);
                                if (!aquifer.method_33742() || state.method_26227().method_15769()) continue;
                                mutable.method_10103(absoluteX, absoluteY, absoluteZ);
                                chunkAccess.method_12039((class_2338)mutable);
                            }
                        }
                    }
                }
            }
            noiseChunk.method_38348();
        }
        noiseChunk.method_40537();
        return chunkAccess;
    }

    private int sampleElevation(int x, int z) {
        return ((MapInfo)this.mapInfo.comp_349()).getHeightMapElevation(x, z, this.method_33730() - 1);
    }

    @Deprecated
    private double computeBeardDensity(int distanceBelowTop, double finalDensity, class_6910 beardifier, class_6568 noiseChunk) {
        double beard = beardifier.method_40464((class_6910.class_6912)noiseChunk);
        if (beard > 0.0) {
            double softening = distanceBelowTop >= 0 ? finalDensity : (double)distanceBelowTop * 0.025;
            return softening + beard;
        }
        return -1.0;
    }

    public class_6880<MapInfo> getMapInfo() {
        return this.mapInfo;
    }

    public class_6910 getUndergroundDensityFunction() {
        return this.undergroundDensityFunction;
    }

    public boolean isEnableCarvers() {
        return this.enableCarvers;
    }

    private class_2680 sampleState(class_6568 noiseChunk) {
        class_2680 state = ((NoiseChunkAccessor)noiseChunk).invokeGetInterpolatedState();
        if (state == null) {
            return this.defaultBlock();
        }
        return state;
    }

    private class_2680 defaultFluid() {
        return ((class_5284)this.method_41541().comp_349()).comp_476();
    }

    private class_2680 defaultBlock() {
        return ((class_5284)this.method_41541().comp_349()).comp_475();
    }
}

