/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.ColorMapBiomeProvider;
import java.util.Optional;
import java.util.function.IntPredicate;

public record BiomeLayerEntry(Range yRange, ColorMapBiomeProvider biomeProvider) {
    public static final Codec<BiomeLayerEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Range.CODEC.fieldOf("y_range").forGetter(BiomeLayerEntry::yRange), (App)ColorMapBiomeProvider.CODEC.codec().fieldOf("biomes").forGetter(BiomeLayerEntry::biomeProvider)).apply((Applicative)instance, BiomeLayerEntry::new));

    public boolean isInLayer(int y) {
        return this.yRange.test(y);
    }

    private record Range(Optional<Integer> min, Optional<Integer> max) implements IntPredicate
    {
        public static final Codec<Range> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min").forGetter(Range::min), (App)Codec.INT.optionalFieldOf("max").forGetter(Range::max)).apply((Applicative)instance, Range::new)).validate(range -> {
            int maxValue;
            int minValue = range.min.orElse(Integer.MIN_VALUE);
            if (minValue >= (maxValue = range.max.orElse(Integer.MAX_VALUE).intValue())) {
                return DataResult.error(() -> "Min is not less than max in: " + String.valueOf(range), (Object)range);
            }
            return DataResult.success((Object)range);
        });

        @Override
        public boolean test(int y) {
            int minValue = this.min.orElse(Integer.MIN_VALUE);
            int maxValue = this.max.orElse(Integer.MAX_VALUE);
            return minValue <= y && y <= maxValue;
        }
    }
}

