/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.LayeredMapBiomeProvider;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class ColorMapBiomeSource
extends class_1966 {
    public static final MapCodec<ColorMapBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MapInfo.CODEC.fieldOf("map_info").forGetter(ColorMapBiomeSource::getMapInfo), (App)class_1959.field_24677.fieldOf("default_biome").forGetter(ColorMapBiomeSource::getDefaultBiome)).apply((Applicative)instance, ColorMapBiomeSource::new));
    private final class_6880<MapInfo> mapInfo;
    private final class_6880<class_1959> defaultBiome;

    public ColorMapBiomeSource(class_6880<MapInfo> mapInfo, class_6880<class_1959> defaultBiome) {
        this.mapInfo = mapInfo;
        this.defaultBiome = defaultBiome;
    }

    protected MapCodec<? extends ColorMapBiomeSource> method_28442() {
        return CODEC;
    }

    @NotNull
    protected Stream<class_6880<class_1959>> method_49494() {
        MapInfo mapInfoValue = (MapInfo)this.mapInfo.comp_349();
        Stream<class_6880<class_1959>> baseBiomes = mapInfoValue.surfaceBiomes().collectPossibleBiomes();
        Optional<LayeredMapBiomeProvider> caveBiomes = mapInfoValue.caveBiomes();
        if (caveBiomes.isPresent()) {
            baseBiomes = Stream.concat(baseBiomes, mapInfoValue.caveBiomes().orElseThrow().collectPossibleBiomes());
        }
        return Stream.concat(Stream.of(this.defaultBiome), baseBiomes);
    }

    public class_6880<class_1959> method_38109(int biomeX, int biomeY, int biomeZ, class_6544.class_6552 sampler) {
        MapInfo info = (MapInfo)this.mapInfo.comp_349();
        int x = class_5742.method_33101((int)biomeX);
        int y = class_5742.method_33101((int)biomeY);
        int z = class_5742.method_33101((int)biomeZ);
        return info.getBiome(x, y, z, this.defaultBiome);
    }

    public class_6880<MapInfo> getMapInfo() {
        return this.mapInfo;
    }

    public class_6880<class_1959> getDefaultBiome() {
        return this.defaultBiome;
    }
}

