/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.registry.NovoAtlasResourceKeys;
import com.thedeathlycow.novoatlas.world.gen.MapImage;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import com.thedeathlycow.novoatlas.world.gen.biome.BiomeColorEntry;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.BiomeMapProvider;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public final class ColorMapBiomeProvider
implements BiomeMapProvider {
    public static final MapCodec<ColorMapBiomeProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154(NovoAtlasResourceKeys.BIOME_MAP).fieldOf("map").forGetter(ColorMapBiomeProvider::getMap), (App)BiomeColorEntry.LIST_CODEC.fieldOf("biomes").forGetter(ColorMapBiomeProvider::getBiomeColors), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(ColorMapBiomeProvider::isStrict)).apply((Applicative)instance, ColorMapBiomeProvider::new));
    private final class_5321<MapImage> map;
    private final List<BiomeColorEntry> biomeColors;
    private final boolean strict;
    private final Int2ObjectMap<class_6880<class_1959>> biomeToColorCache = new Int2ObjectArrayMap();

    public ColorMapBiomeProvider(class_5321<MapImage> map, List<BiomeColorEntry> biomeColors, boolean strict) {
        this.map = map;
        this.biomeColors = biomeColors;
        this.strict = strict;
        for (BiomeColorEntry entry : biomeColors) {
            this.biomeToColorCache.put(entry.color(), entry.biome());
        }
    }

    @Override
    @Nullable
    public class_6880<class_1959> getBiome(int x, int y, int z, MapInfo info) {
        MapImage image = MapInfo.lookupBiomeMap(this.map);
        int color = image.sample(x, z, info, Integer.MIN_VALUE);
        if (color == Integer.MIN_VALUE) {
            return null;
        }
        class_6880 mappedBiome = (class_6880)this.biomeToColorCache.get(color);
        if (mappedBiome != null) {
            return mappedBiome;
        }
        if (this.strict) {
            return null;
        }
        return this.getClosest(color);
    }

    @Override
    public Stream<class_6880<class_1959>> collectPossibleBiomes() {
        return this.biomeColors.stream().map(BiomeColorEntry::biome);
    }

    public MapCodec<ColorMapBiomeProvider> getCodec() {
        return CODEC;
    }

    public class_5321<MapImage> getMap() {
        return this.map;
    }

    public List<BiomeColorEntry> getBiomeColors() {
        return this.biomeColors;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Nullable
    private class_6880<class_1959> getClosest(int color) {
        double closestDistance = 2.147483647E9;
        int closest = -1;
        int red = ColorMapBiomeProvider.red(color);
        int green = ColorMapBiomeProvider.green(color);
        int blue = ColorMapBiomeProvider.blue(color);
        IntIterator intIterator = this.biomeToColorCache.keySet().iterator();
        while (intIterator.hasNext()) {
            int dBlue;
            int dGreen;
            int candidate = (Integer)intIterator.next();
            int dRed = ColorMapBiomeProvider.red(candidate) - red;
            double candidateDistance = dRed * dRed + (dGreen = ColorMapBiomeProvider.green(candidate) - green) * dGreen + (dBlue = ColorMapBiomeProvider.blue(candidate) - blue) * dBlue;
            if (!(candidateDistance < closestDistance)) continue;
            closestDistance = candidateDistance;
            closest = candidate;
        }
        return (class_6880)this.biomeToColorCache.getOrDefault(closest, null);
    }

    private static int red(int color) {
        return color & 0xFF;
    }

    private static int green(int color) {
        return color & 0xFF;
    }

    private static int blue(int color) {
        return color & 0xFF;
    }
}

