/*
 * Decompiled with CFR 0.152.
 */
package com.thedeathlycow.novoatlas.world.gen.biome.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedeathlycow.novoatlas.NovoAtlas;
import com.thedeathlycow.novoatlas.world.gen.MapInfo;
import com.thedeathlycow.novoatlas.world.gen.biome.BiomeLayerEntry;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.BiomeMapProvider;
import com.thedeathlycow.novoatlas.world.gen.biome.provider.ColorMapBiomeProvider;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record LayeredMapBiomeProvider(List<BiomeLayerEntry> layers) implements BiomeMapProvider
{
    public static final class_5321<class_1959> SURFACE_BIOME = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)NovoAtlas.loc("surface_biome"));
    public static final MapCodec<LayeredMapBiomeProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeLayerEntry.CODEC.listOf().fieldOf("layers").forGetter(LayeredMapBiomeProvider::layers)).apply((Applicative)instance, LayeredMapBiomeProvider::new));

    @Override
    @Nullable
    public class_6880<class_1959> getBiome(int x, int y, int z, MapInfo info) {
        class_6880<class_1959> colorMapBiome = this.getBiomeFromColorMap(x, y, z, info);
        return colorMapBiome != null && !colorMapBiome.method_40225(SURFACE_BIOME) ? colorMapBiome : null;
    }

    @Override
    public Stream<class_6880<class_1959>> collectPossibleBiomes() {
        return this.layers.stream().map(BiomeLayerEntry::biomeProvider).flatMap(ColorMapBiomeProvider::collectPossibleBiomes);
    }

    public MapCodec<LayeredMapBiomeProvider> getCodec() {
        return CODEC;
    }

    @Nullable
    private BiomeLayerEntry getLayer(int y) {
        for (BiomeLayerEntry layer : this.layers) {
            if (!layer.isInLayer(y)) continue;
            return layer;
        }
        return null;
    }

    private class_6880<class_1959> getBiomeFromColorMap(int x, int y, int z, MapInfo info) {
        int elevation = info.getHeightMapElevation(x, z, Integer.MIN_VALUE);
        if (elevation == Integer.MIN_VALUE) {
            return null;
        }
        BiomeLayerEntry layer = this.getLayer(y);
        return layer != null ? layer.biomeProvider().getBiome(x, y, z, info) : null;
    }
}

