/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.api.trinket;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Rarity;
import owmii.losttrinkets.lib.client.util.MC;

public class Trinket<T extends Trinket<?>>
extends class_1792
implements ITrinket {
    private final Map<class_1320, class_1322> attributes = Maps.newHashMap();
    private final Rarity rarity;
    protected boolean unlockable = true;
    public static final int TOOLTIP_MAX_WIDTH = 240;

    public Trinket(Rarity rarity, class_1792.class_1793 properties) {
        super(properties.method_7889(1));
        this.rarity = rarity;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (LostTrinketsAPI.get().unlock(player, this)) {
            class_1799 stack = player.method_5998(hand);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            return class_1271.method_22428((Object)stack);
        }
        return super.method_7836(world, player, hand);
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        if (LostTrinketsAPI.get().isDisabled(this)) {
            tooltip.add((class_2561)new class_2588("gui.losttrinkets.status.disabled").method_27692(class_124.field_1079));
        } else {
            class_1657 player = MC.player().orElse(null);
            if (player != null && LostTrinketsAPI.getTrinkets(player).has(this)) {
                tooltip.add((class_2561)new class_2588("gui.losttrinkets.status.owned").method_27692(class_124.field_1078));
            } else if (LostTrinketsAPI.get().isNonRandom(this)) {
                tooltip.add((class_2561)new class_2588("gui.losttrinkets.status.non_random").method_27692(class_124.field_1063));
            }
        }
        ArrayList temp = new ArrayList();
        this.addTrinketDescription(stack, temp);
        class_5225 textHandler = class_310.method_1551().field_1772.method_27527();
        tooltip.addAll(temp.stream().flatMap(text -> textHandler.method_27495((class_5348)text, 240, class_2583.field_24360).stream()).map(styled -> (class_5250)styled.method_27658((style, literal) -> Optional.of(new class_2585(literal).method_10862(style)), class_2583.field_24360).get()).collect(Collectors.toList()));
        tooltip.add((class_2561)new class_2588("gui.losttrinkets.rarity." + this.getRarity().name().toLowerCase(Locale.ENGLISH)).method_27692(class_124.field_1063));
    }

    public class_2561 method_7864(class_1799 stack) {
        return super.method_7864(stack).method_27661().method_27696(this.getRarity().getStyle());
    }

    @Override
    public void onActivated(class_1937 world, class_2338 pos, class_1657 player) {
    }

    @Override
    public void onDeactivated(class_1937 world, class_2338 pos, class_1657 player) {
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isUnlockable() {
        return this.unlockable;
    }

    public Trinket<T> noUnlock() {
        this.unlockable = false;
        return this;
    }

    @Override
    public void setUnlockable(boolean unlockable) {
        this.unlockable = unlockable;
    }

    public T add(class_1320 attribute, String uuid, double amount) {
        class_1322 attributemodifier = new class_1322(UUID.fromString(uuid), "Attribute", amount, class_1322.class_1323.field_6328);
        this.getAttributes().put(attribute, attributemodifier);
        return (T)this;
    }

    public void applyAttributes(class_1657 player) {
        for (Map.Entry<class_1320, class_1322> entry : this.getAttributes().entrySet()) {
            class_1322 attributeModifier;
            class_1324 attribute = player.method_5996(entry.getKey());
            if (attribute == null || attribute.method_6196(attributeModifier = entry.getValue())) continue;
            attribute.method_26837(attributeModifier);
        }
    }

    public void removeAttributes(class_1657 player) {
        for (Map.Entry<class_1320, class_1322> entry : this.getAttributes().entrySet()) {
            class_1324 attribute = player.method_5996(entry.getKey());
            if (attribute == null) continue;
            attribute.method_6202(entry.getValue());
        }
    }

    public Map<class_1320, class_1322> getAttributes() {
        return this.attributes;
    }

    public boolean method_7886(class_1799 stack) {
        return true;
    }
}

