/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.api.trinket;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import owmii.losttrinkets.LostTrinkets;
import owmii.losttrinkets.api.LostTrinketsAPI;
import owmii.losttrinkets.api.player.PlayerData;
import owmii.losttrinkets.api.trinket.ITargetingTrinket;
import owmii.losttrinkets.api.trinket.ITickableTrinket;
import owmii.losttrinkets.api.trinket.ITrinket;
import owmii.losttrinkets.api.trinket.Trinket;

public class Trinkets {
    private final List<ITrinket> available = new ArrayList<ITrinket>();
    private final List<ITrinket> active = new ArrayList<ITrinket>();
    private final List<ITickableTrinket> tickable = new ArrayList<ITickableTrinket>();
    private final List<ITargetingTrinket> targeting = new ArrayList<ITargetingTrinket>();
    private final PlayerData data;
    private int slots = 1;
    private boolean slotsSet;

    public Trinkets(PlayerData data) {
        this.data = data;
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("slots", this.slots);
        nbt.method_10556("slots_set", this.slotsSet);
        class_2499 availableTrinkets = new class_2499();
        this.available.forEach(trinket -> {
            class_2487 nbt1 = new class_2487();
            class_2960 location = class_2378.field_11142.method_10221((Object)trinket.method_8389());
            Objects.requireNonNull(location);
            nbt1.method_10582("trinket", location.toString());
            availableTrinkets.add((Object)nbt1);
        });
        nbt.method_10566("available_trinkets", (class_2520)availableTrinkets);
        class_2499 activeTrinkets = new class_2499();
        this.active.forEach(trinket -> {
            class_2487 nbt1 = new class_2487();
            class_2960 location = class_2378.field_11142.method_10221((Object)trinket.method_8389());
            Objects.requireNonNull(location);
            nbt1.method_10582("trinket", location.toString());
            activeTrinkets.add((Object)nbt1);
        });
        nbt.method_10566("active_trinkets", (class_2520)activeTrinkets);
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.slots = nbt.method_10550("slots");
        this.slotsSet = nbt.method_10577("slots_set");
        class_2499 availableTrinkets = nbt.method_10554("available_trinkets", 10);
        this.available.clear();
        for (int i = 0; i < availableTrinkets.size(); ++i) {
            class_2487 nbt1 = availableTrinkets.method_10602(i);
            class_1792 trinket = (class_1792)class_2378.field_11142.method_10223(new class_2960(nbt1.method_10558("trinket")));
            if (!(trinket instanceof ITrinket)) continue;
            this.available.add((ITrinket)trinket);
        }
        class_2499 activeTrinkets = nbt.method_10554("active_trinkets", 10);
        this.active.clear();
        this.tickable.clear();
        this.targeting.clear();
        for (int i = 0; i < activeTrinkets.size(); ++i) {
            class_2487 nbt1 = activeTrinkets.method_10602(i);
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(nbt1.method_10558("trinket")));
            if (!(item instanceof ITrinket)) continue;
            ITrinket trinket = (ITrinket)item;
            if (this.active.size() >= this.slots) continue;
            this.active.add(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.add((ITickableTrinket)trinket);
            }
            if (!(trinket instanceof ITargetingTrinket)) continue;
            this.targeting.add((ITargetingTrinket)trinket);
        }
    }

    public boolean unlockSlot() {
        if (this.slots < LostTrinkets.config().maxSlots) {
            ++this.slots;
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public int getSlots() {
        return this.slots;
    }

    public void initSlots(int slots) {
        if (!this.slotsSet) {
            this.setSlots(slots);
            this.slotsSet = true;
        }
    }

    public void setSlots(int slots) {
        this.slots = slots;
        this.data.setSync(true);
    }

    public boolean clear() {
        if (!this.available.isEmpty() || !this.active.isEmpty()) {
            this.available.clear();
            this.active.clear();
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean give(ITrinket trinket) {
        if (!this.has(trinket)) {
            this.available.add(trinket);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean setActive(ITrinket trinket, class_1657 player) {
        if (this.isAvailable(trinket)) {
            this.forceActive(trinket, player);
            this.available.remove(trinket);
            return true;
        }
        return false;
    }

    public boolean setInactive(ITrinket trinket, class_1657 player) {
        if (this.isActive(trinket)) {
            this.available.add(trinket);
            this.active.remove(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.remove(trinket);
            }
            if (trinket instanceof ITargetingTrinket) {
                this.targeting.remove(trinket);
            }
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).removeAttributes(player);
            }
            trinket.onDeactivated(player.field_6002, player.method_24515(), player);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public boolean forceActive(ITrinket trinket, class_1657 player) {
        if (!this.isActive(trinket) && this.active.size() < this.slots) {
            this.active.add(trinket);
            if (trinket instanceof ITickableTrinket) {
                this.tickable.add((ITickableTrinket)trinket);
            }
            if (trinket instanceof ITargetingTrinket) {
                this.targeting.add((ITargetingTrinket)trinket);
            }
            if (trinket instanceof Trinket) {
                ((Trinket)trinket).applyAttributes(player);
            }
            trinket.onActivated(player.field_6002, player.method_24515(), player);
            this.data.setSync(true);
            return true;
        }
        return false;
    }

    public void removeDisabled(class_1657 player) {
        this.getActiveTrinkets().stream().filter(LostTrinketsAPI.get()::isDisabled).collect(Collectors.toList()).forEach(trinket -> this.setInactive((ITrinket)trinket, player));
        if (this.getAvailableTrinkets().removeIf(LostTrinketsAPI.get()::isDisabled)) {
            this.data.setSync(true);
        }
    }

    public boolean has(ITrinket trinket) {
        return this.isActive(trinket) || this.isAvailable(trinket);
    }

    public boolean isActive(ITrinket trinket) {
        return this.active.contains(trinket);
    }

    public boolean isActive(Supplier<? extends ITrinket> trinket) {
        return this.active.contains(trinket.get());
    }

    public boolean isAvailable(ITrinket trinket) {
        return this.available.contains(trinket);
    }

    public List<ITrinket> getActiveTrinkets() {
        return this.active;
    }

    public List<ITrinket> getAvailableTrinkets() {
        return this.available;
    }

    public List<ITickableTrinket> getTickable() {
        return this.tickable;
    }

    public List<ITargetingTrinket> getTargeting() {
        return this.targeting;
    }
}

