/*
 * Decompiled with CFR 0.152.
 */
package owmii.losttrinkets.config;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.cloth.clothconfig.shadowed.com.moandjiezana.toml.Toml;
import me.shedaniel.cloth.clothconfig.shadowed.com.moandjiezana.toml.TomlWriter;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import owmii.losttrinkets.LostTrinkets;

@Config(name="losttrinkets")
public class SunkenTrinketsConfig
implements ConfigData {
    public static final Marker MARKER = new MarkerManager.Log4jMarker("Config");
    @Comment(value="Set to false to disable the default way of unlocking trinkets.")
    public boolean unlockEnabled = true;
    @Comment(value="Range: 0 ~ 1728000")
    public long unlockCooldown = 2400L;
    public List<String> blackList = new ArrayList<String>();
    public List<String> nonRandom = new ArrayList<String>();
    public int startSlots = 1;
    public int maxSlots = 40;
    public int slotCost = 15;
    public int slotUpFactor = 3;
    public static final int killingDefault = 120;
    public static final int bossKillingDefault = 10;
    public static final int farmingDefault = 140;
    public static final int oresMiningDefault = 100;
    public static final int tradingDefault = 30;
    public static final int woodCuttingDefault = 170;
    public boolean killingUnlockEnabled = true;
    public int killing = 120;
    public boolean bossKillingUnlockEnabled = true;
    public int bossKilling = 10;
    public boolean farmingUnlockEnabled = true;
    public int farming = 140;
    public boolean oresMiningUnlockEnabled = true;
    public int oresMining = 100;
    public boolean tradingUnlockEnabled = true;
    public int trading = 30;
    public boolean woodCuttingUnlockEnabled = true;
    public int woodCutting = 170;

    public void validatePostLoad() throws ConfigData.ValidationException {
    }

    public int calcCost(int currentSlosts) {
        if (currentSlosts >= this.maxSlots) {
            return -1;
        }
        int startSlots = this.startSlots;
        if (currentSlosts < startSlots) {
            return 0;
        }
        return this.slotCost + (currentSlosts - startSlots) * this.slotUpFactor;
    }

    private static class_2588 tr(String key) {
        return new class_2588("gui.losttrinkets.config." + key);
    }

    private static SubCategoryBuilder makeUnlocksSubcategory(SunkenTrinketsConfig config, ConfigEntryBuilder entryBuilder, String name, int defaultValue) {
        SubCategoryBuilder cat = entryBuilder.startSubCategory((class_2561)SunkenTrinketsConfig.tr(name + "Unlocks"));
        try {
            String unlockEnabledName = name + "UnlockEnabled";
            Field unlockEnabledField = SunkenTrinketsConfig.class.getDeclaredField(unlockEnabledName);
            cat.add((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)SunkenTrinketsConfig.tr(unlockEnabledName + ".text"), ((Boolean)Utils.getUnsafely((Field)unlockEnabledField, (Object)config, (Object)true)).booleanValue()).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr(unlockEnabledName + ".tooltip")}).setDefaultValue(true).setSaveConsumer(v -> Utils.setUnsafely((Field)unlockEnabledField, (Object)config, (Object)v)).build());
            Field rarityField = SunkenTrinketsConfig.class.getDeclaredField(name);
            cat.add((AbstractConfigListEntry)entryBuilder.startIntField((class_2561)SunkenTrinketsConfig.tr(name + ".text"), ((Integer)Utils.getUnsafely((Field)rarityField, (Object)config, (Object)defaultValue)).intValue()).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr(name + ".tooltip")}).setDefaultValue(defaultValue).setMin(2).setMax(100000).setSaveConsumer(v -> Utils.setUnsafely((Field)rarityField, (Object)config, (Object)v)).build());
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to serialize unlocks: " + name, e);
        }
        return cat;
    }

    public static ConfigBuilder builder() {
        SunkenTrinketsConfig config = (SunkenTrinketsConfig)LostTrinkets.CONFIG.getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setTitle((class_2561)SunkenTrinketsConfig.tr("title"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory defaultCategory = builder.getOrCreateCategory((class_2561)SunkenTrinketsConfig.tr("category.default"));
        defaultCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)SunkenTrinketsConfig.tr("unlockEnabled.text"), config.unlockEnabled).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("unlockEnabled.tooltip")}).setDefaultValue(true).setSaveConsumer(v -> {
            config.unlockEnabled = v;
        }).build());
        defaultCategory.addEntry((AbstractConfigListEntry)entryBuilder.startLongField((class_2561)SunkenTrinketsConfig.tr("unlockCooldown.text"), config.unlockCooldown).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("unlockCooldown.tooltip")}).setDefaultValue(2400L).setMin(0L).setMax(1728000L).setSaveConsumer(v -> {
            config.unlockCooldown = v;
        }).build());
        SubCategoryBuilder cat = entryBuilder.startSubCategory((class_2561)SunkenTrinketsConfig.tr("blackList.text"));
        cat.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)SunkenTrinketsConfig.tr("blackList.desc")).build());
        cat.add((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)SunkenTrinketsConfig.tr("blackList.label"), config.blackList).setDefaultValue(new ArrayList()).setSaveConsumer(v -> {
            config.blackList = v;
        }).requireRestart().build());
        defaultCategory.addEntry((AbstractConfigListEntry)cat.build());
        cat = entryBuilder.startSubCategory((class_2561)SunkenTrinketsConfig.tr("nonRandom.text"));
        cat.add((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)SunkenTrinketsConfig.tr("nonRandom.desc")).build());
        cat.add((AbstractConfigListEntry)entryBuilder.startStrList((class_2561)SunkenTrinketsConfig.tr("nonRandom.label"), config.nonRandom).setDefaultValue(new ArrayList()).setSaveConsumer(v -> {
            config.nonRandom = v;
        }).requireRestart().build());
        defaultCategory.addEntry((AbstractConfigListEntry)cat.build());
        cat = entryBuilder.startSubCategory((class_2561)SunkenTrinketsConfig.tr("trinketSlots"));
        cat.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)SunkenTrinketsConfig.tr("startSlots.text"), config.startSlots, 0, 40).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("startSlots.tooltip")}).setDefaultValue(1).setSaveConsumer(v -> {
            config.startSlots = v;
        }).build());
        cat.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)SunkenTrinketsConfig.tr("maxSlots.text"), config.maxSlots, 1, 40).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("maxSlots.tooltip")}).setDefaultValue(40).setSaveConsumer(v -> {
            config.maxSlots = v;
        }).build());
        cat.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)SunkenTrinketsConfig.tr("slotCost.text"), config.slotCost, 0, 1000).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("slotCost.tooltip")}).setDefaultValue(15).setSaveConsumer(v -> {
            config.slotCost = v;
        }).build());
        cat.add((AbstractConfigListEntry)entryBuilder.startIntSlider((class_2561)SunkenTrinketsConfig.tr("slotUpFactor.text"), config.slotUpFactor, 0, 1000).setTooltip(new class_2561[]{SunkenTrinketsConfig.tr("slotUpFactor.tooltip")}).setDefaultValue(3).setSaveConsumer(v -> {
            config.slotUpFactor = v;
        }).build());
        defaultCategory.addEntry((AbstractConfigListEntry)cat.build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "killing", 120).build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "bossKilling", 10).build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "farming", 140).build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "oresMining", 100).build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "trading", 30).build());
        defaultCategory.addEntry((AbstractConfigListEntry)SunkenTrinketsConfig.makeUnlocksSubcategory(config, entryBuilder, "woodCutting", 170).build());
        builder.setSavingRunnable(() -> LostTrinkets.CONFIG.save());
        return builder;
    }

    public static ConfigHolder<SunkenTrinketsConfig> register() {
        return AutoConfig.register(SunkenTrinketsConfig.class, (cfg, cfgClass) -> new Serializer());
    }

    public static class Serializer
    implements ConfigSerializer<SunkenTrinketsConfig> {
        public SunkenTrinketsConfig createDefault() {
            return new SunkenTrinketsConfig();
        }

        private Path getConfigPath() {
            return Utils.getConfigFolder().resolve("losttrinkets").resolve("general_common.toml");
        }

        private static void deserializeUnlocks(SunkenTrinketsConfig config, Toml toml, String tableName, String name, int defaultValue) {
            if (!toml.containsTable(tableName)) {
                return;
            }
            Toml table = toml.getTable(tableName);
            try {
                String unlockEnabledName = name + "UnlockEnabled";
                Field unlockEnabledField = SunkenTrinketsConfig.class.getDeclaredField(unlockEnabledName);
                if (table.contains(unlockEnabledName)) {
                    Utils.setUnsafely((Field)unlockEnabledField, (Object)config, (Object)table.getBoolean(unlockEnabledName));
                }
                Field rarityField = SunkenTrinketsConfig.class.getDeclaredField(name);
                if (table.contains(name)) {
                    Utils.setUnsafely((Field)rarityField, (Object)config, (Object)((int)table.getLong(name).longValue()));
                }
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to serialize unlocks: " + name, e);
            }
        }

        public SunkenTrinketsConfig deserialize() throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            if (Files.exists(configPath, new LinkOption[0])) {
                SunkenTrinketsConfig config = this.createDefault();
                Toml toml = new Toml().read(configPath.toFile());
                config.unlockEnabled = toml.getBoolean("unlockEnabled", Boolean.valueOf(true));
                if (toml.containsPrimitive("unlockCooldown")) {
                    config.unlockCooldown = toml.getLong("unlockCooldown");
                }
                if (toml.contains("blackList")) {
                    config.blackList = toml.getList("blackList");
                }
                if (toml.contains("nonRandom")) {
                    config.nonRandom = toml.getList("nonRandom");
                }
                if (toml.containsTable("Trinket_Slots")) {
                    Toml tab = toml.getTable("Trinket_Slots");
                    config.slotUpFactor = (int)tab.getLong("slotUpFactor").longValue();
                    config.maxSlots = (int)tab.getLong("maxSlots").longValue();
                    config.startSlots = (int)tab.getLong("startSlots").longValue();
                    config.slotCost = (int)tab.getLong("slotCost").longValue();
                }
                Serializer.deserializeUnlocks(config, toml, "Killing_Unlocks", "killing", 120);
                Serializer.deserializeUnlocks(config, toml, "Bosses_Killing_Unlocks", "bossKilling", 10);
                Serializer.deserializeUnlocks(config, toml, "Farming_Unlocks", "farming", 140);
                Serializer.deserializeUnlocks(config, toml, "Ores_Mining_Unlocks", "oresMining", 100);
                Serializer.deserializeUnlocks(config, toml, "Trading_Unlocks", "trading", 30);
                Serializer.deserializeUnlocks(config, toml, "Wood_Cutting_Unlocks", "woodCutting", 170);
                return config;
            }
            return this.createDefault();
        }

        private static Map<String, Object> serializeUnlocks(SunkenTrinketsConfig config, String name, int defaultValue) {
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            try {
                String unlockEnabledName = name + "UnlockEnabled";
                Field unlockEnabledField = SunkenTrinketsConfig.class.getDeclaredField(unlockEnabledName);
                data.put(unlockEnabledName, Utils.getUnsafely((Field)unlockEnabledField, (Object)config, (Object)true));
                Field rarityField = SunkenTrinketsConfig.class.getDeclaredField(name);
                data.put(name, Utils.getUnsafely((Field)rarityField, (Object)config, (Object)defaultValue));
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Failed to serialize unlocks: " + name, e);
            }
            return data;
        }

        public void serialize(SunkenTrinketsConfig config) throws ConfigSerializer.SerializationException {
            Path configPath = this.getConfigPath();
            try {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                LinkedHashMap<String, Object> configData = new LinkedHashMap<String, Object>();
                configData.put("unlockEnabled", config.unlockEnabled);
                configData.put("unlockCooldown", config.unlockCooldown);
                configData.put("blackList", config.blackList);
                configData.put("nonRandom", config.nonRandom);
                LinkedHashMap<String, Integer> data = new LinkedHashMap<String, Integer>();
                data.put("slotUpFactor", config.slotUpFactor);
                data.put("maxSlots", config.maxSlots);
                data.put("startSlots", config.startSlots);
                data.put("slotCost", config.slotCost);
                configData.put("Trinket_Slots", data);
                configData.put("Killing_Unlocks", Serializer.serializeUnlocks(config, "killing", 120));
                configData.put("Bosses_Killing_Unlocks", Serializer.serializeUnlocks(config, "bossKilling", 10));
                configData.put("Farming_Unlocks", Serializer.serializeUnlocks(config, "farming", 140));
                configData.put("Ores_Mining_Unlocks", Serializer.serializeUnlocks(config, "oresMining", 100));
                configData.put("Trading_Unlocks", Serializer.serializeUnlocks(config, "trading", 30));
                configData.put("Wood_Cutting_Unlocks", Serializer.serializeUnlocks(config, "woodCutting", 170));
                TomlWriter writer = new TomlWriter();
                writer.write(configData, configPath.toFile());
            }
            catch (IOException var4) {
                throw new ConfigSerializer.SerializationException((Throwable)var4);
            }
        }
    }
}

